/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.SourceLocation;
import com.facebook.presto.jdbc.internal.spi.function.FunctionHandle;
import com.facebook.presto.jdbc.internal.spi.plan.LogicalProperties;
import com.facebook.presto.jdbc.internal.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.jdbc.internal.spi.plan.OrderingScheme;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNode;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import com.facebook.presto.jdbc.internal.spi.plan.PlanVisitor;
import com.facebook.presto.jdbc.internal.spi.relation.CallExpression;
import com.facebook.presto.jdbc.internal.spi.relation.RowExpression;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Immutable
public final class AggregationNode
extends PlanNode {
    private final PlanNode source;
    private final Map<VariableReferenceExpression, Aggregation> aggregations;
    private final GroupingSetDescriptor groupingSets;
    private final List<VariableReferenceExpression> preGroupedVariables;
    private final Step step;
    private final Optional<VariableReferenceExpression> hashVariable;
    private final Optional<VariableReferenceExpression> groupIdVariable;
    private final List<VariableReferenceExpression> outputs;

    @JsonCreator
    public AggregationNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="aggregations") Map<VariableReferenceExpression, Aggregation> aggregations, @JsonProperty(value="groupingSets") GroupingSetDescriptor groupingSets, @JsonProperty(value="preGroupedVariables") List<VariableReferenceExpression> preGroupedVariables, @JsonProperty(value="step") Step step, @JsonProperty(value="hashVariable") Optional<VariableReferenceExpression> hashVariable, @JsonProperty(value="groupIdVariable") Optional<VariableReferenceExpression> groupIdVariable) {
        this(sourceLocation, id, Optional.empty(), source, aggregations, groupingSets, preGroupedVariables, step, hashVariable, groupIdVariable);
    }

    public AggregationNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, PlanNode source, Map<VariableReferenceExpression, Aggregation> aggregations, GroupingSetDescriptor groupingSets, List<VariableReferenceExpression> preGroupedVariables, Step step, Optional<VariableReferenceExpression> hashVariable, Optional<VariableReferenceExpression> groupIdVariable) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.source = source;
        this.aggregations = Collections.unmodifiableMap(new LinkedHashMap<VariableReferenceExpression, Aggregation>(Objects.requireNonNull(aggregations, "aggregations is null")));
        Objects.requireNonNull(groupingSets, "groupingSets is null");
        groupIdVariable.ifPresent(variable -> AggregationNode.checkArgument(groupingSets.getGroupingKeys().contains(variable), "Grouping columns does not contain groupId column"));
        this.groupingSets = groupingSets;
        this.groupIdVariable = Objects.requireNonNull(groupIdVariable);
        boolean noOrderBy = aggregations.values().stream().map(Aggregation::getOrderBy).noneMatch(Optional::isPresent);
        AggregationNode.checkArgument(noOrderBy || step == Step.SINGLE, "ORDER BY does not support distributed aggregation");
        this.step = step;
        this.hashVariable = hashVariable;
        Objects.requireNonNull(preGroupedVariables, "preGroupedVariables is null");
        AggregationNode.checkArgument(preGroupedVariables.isEmpty() || groupingSets.getGroupingKeys().containsAll(preGroupedVariables), "Pre-grouped variables must be a subset of the grouping keys");
        this.preGroupedVariables = Collections.unmodifiableList(new ArrayList<VariableReferenceExpression>(preGroupedVariables));
        ArrayList<VariableReferenceExpression> keys = new ArrayList<VariableReferenceExpression>(groupingSets.getGroupingKeys());
        hashVariable.ifPresent(keys::add);
        keys.addAll(new ArrayList<VariableReferenceExpression>(aggregations.keySet()));
        this.outputs = Collections.unmodifiableList(keys);
    }

    public static boolean isDistinct(AggregationNode node) {
        return node.getAggregations().isEmpty() && node.getOutputVariables().size() == node.getGroupingKeys().size() && node.getOutputVariables().containsAll(node.getGroupingKeys());
    }

    public List<VariableReferenceExpression> getGroupingKeys() {
        return this.groupingSets.getGroupingKeys();
    }

    @JsonProperty
    public GroupingSetDescriptor getGroupingSets() {
        return this.groupingSets;
    }

    public boolean hasDefaultOutput() {
        return this.hasEmptyGroupingSet() && (this.step.isOutputPartial() || this.step.equals((Object)Step.SINGLE));
    }

    public boolean hasEmptyGroupingSet() {
        return !this.groupingSets.getGlobalGroupingSets().isEmpty();
    }

    public boolean hasNonEmptyGroupingSet() {
        return this.groupingSets.getGroupingSetCount() > this.groupingSets.getGlobalGroupingSets().size();
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.singletonList(this.source);
    }

    @Override
    public LogicalProperties computeLogicalProperties(LogicalPropertiesProvider logicalPropertiesProvider) {
        Objects.requireNonNull(logicalPropertiesProvider, "logicalPropertiesProvider cannot be null.");
        return logicalPropertiesProvider.getAggregationProperties(this);
    }

    @Override
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputs;
    }

    @JsonProperty
    public Map<VariableReferenceExpression, Aggregation> getAggregations() {
        return this.aggregations;
    }

    @JsonProperty
    public List<VariableReferenceExpression> getPreGroupedVariables() {
        return this.preGroupedVariables;
    }

    public int getGroupingSetCount() {
        return this.groupingSets.getGroupingSetCount();
    }

    public Set<Integer> getGlobalGroupingSets() {
        return this.groupingSets.getGlobalGroupingSets();
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public Step getStep() {
        return this.step;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getHashVariable() {
        return this.hashVariable;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getGroupIdVariable() {
        return this.groupIdVariable;
    }

    public boolean hasOrderings() {
        return this.aggregations.values().stream().map(Aggregation::getOrderBy).anyMatch(Optional::isPresent);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitAggregation(this, context);
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new AggregationNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.source, this.aggregations, this.groupingSets, this.preGroupedVariables, this.step, this.hashVariable, this.groupIdVariable);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        AggregationNode.checkArgument(newChildren.size() == 1, "Unexpected number of elements in list newChildren");
        return new AggregationNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), newChildren.get(0), this.aggregations, this.groupingSets, this.preGroupedVariables, this.step, this.hashVariable, this.groupIdVariable);
    }

    public boolean isStreamable() {
        return !this.preGroupedVariables.isEmpty() && this.groupingSets.getGroupingSetCount() == 1 && this.groupingSets.getGlobalGroupingSets().isEmpty() && this.preGroupedVariables.size() == this.groupingSets.groupingKeys.size();
    }

    public boolean isSegmentedAggregationEligible() {
        return !this.preGroupedVariables.isEmpty() && this.groupingSets.getGroupingSetCount() == 1 && this.groupingSets.getGlobalGroupingSets().isEmpty() && this.preGroupedVariables.size() < this.groupingSets.groupingKeys.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregationNode that = (AggregationNode)o;
        return Objects.equals(this.source, that.source) && Objects.equals(this.aggregations, that.aggregations) && Objects.equals(this.groupingSets, that.groupingSets) && Objects.equals(this.preGroupedVariables, that.preGroupedVariables) && this.step == that.step && Objects.equals(this.hashVariable, that.hashVariable) && Objects.equals(this.groupIdVariable, that.groupIdVariable) && Objects.equals(this.outputs, that.outputs);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.aggregations, this.groupingSets, this.preGroupedVariables, this.step, this.hashVariable, this.groupIdVariable, this.outputs});
    }

    public static GroupingSetDescriptor globalAggregation() {
        return AggregationNode.singleGroupingSet(Collections.emptyList());
    }

    public static GroupingSetDescriptor singleGroupingSet(List<VariableReferenceExpression> groupingKeys) {
        Set<Integer> globalGroupingSets = groupingKeys.isEmpty() ? Collections.singleton(0) : Collections.emptySet();
        return new GroupingSetDescriptor(groupingKeys, 1, globalGroupingSets);
    }

    public static GroupingSetDescriptor groupingSets(List<VariableReferenceExpression> groupingKeys, int groupingSetCount, Set<Integer> globalGroupingSets) {
        return new GroupingSetDescriptor(groupingKeys, groupingSetCount, globalGroupingSets);
    }

    private static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static class Aggregation {
        private final CallExpression call;
        private final Optional<RowExpression> filter;
        private final Optional<OrderingScheme> orderingScheme;
        private final boolean isDistinct;
        private final Optional<VariableReferenceExpression> mask;

        @JsonCreator
        public Aggregation(@JsonProperty(value="call") CallExpression call, @JsonProperty(value="filter") Optional<RowExpression> filter, @JsonProperty(value="orderBy") Optional<OrderingScheme> orderingScheme, @JsonProperty(value="distinct") boolean isDistinct, @JsonProperty(value="mask") Optional<VariableReferenceExpression> mask) {
            this.call = Objects.requireNonNull(call, "call is null");
            this.filter = Objects.requireNonNull(filter, "filter is null");
            this.orderingScheme = Objects.requireNonNull(orderingScheme, "orderingScheme is null");
            this.isDistinct = isDistinct;
            this.mask = Objects.requireNonNull(mask, "mask is null");
        }

        public static Aggregation removeDistinct(Aggregation aggregation) {
            AggregationNode.checkArgument(aggregation.isDistinct(), "Expected aggregation to have DISTINCT input");
            return new Aggregation(aggregation.getCall(), aggregation.getFilter(), aggregation.getOrderBy(), false, aggregation.getMask());
        }

        @JsonProperty
        public CallExpression getCall() {
            return this.call;
        }

        @JsonProperty
        public FunctionHandle getFunctionHandle() {
            return this.call.getFunctionHandle();
        }

        @JsonProperty
        public List<RowExpression> getArguments() {
            return this.call.getArguments();
        }

        @JsonProperty
        public Optional<OrderingScheme> getOrderBy() {
            return this.orderingScheme;
        }

        @JsonProperty
        public Optional<RowExpression> getFilter() {
            return this.filter;
        }

        @JsonProperty
        public boolean isDistinct() {
            return this.isDistinct;
        }

        @JsonProperty
        public Optional<VariableReferenceExpression> getMask() {
            return this.mask;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Aggregation)) {
                return false;
            }
            Aggregation that = (Aggregation)o;
            return this.isDistinct == that.isDistinct && Objects.equals(this.call, that.call) && Objects.equals(this.filter, that.filter) && Objects.equals(this.orderingScheme, that.orderingScheme) && Objects.equals(this.mask, that.mask);
        }

        public String toString() {
            return "Aggregation{call=" + this.call + ", filter=" + this.filter + ", orderingScheme=" + this.orderingScheme + ", isDistinct=" + this.isDistinct + ", mask=" + this.mask + '}';
        }

        public int hashCode() {
            return Objects.hash(this.call, this.filter, this.orderingScheme, this.isDistinct, this.mask);
        }
    }

    public static enum Step {
        PARTIAL(true, true),
        FINAL(false, false),
        INTERMEDIATE(false, true),
        SINGLE(true, false);

        private final boolean inputRaw;
        private final boolean outputPartial;

        private Step(boolean inputRaw, boolean outputPartial) {
            this.inputRaw = inputRaw;
            this.outputPartial = outputPartial;
        }

        public boolean isInputRaw() {
            return this.inputRaw;
        }

        public boolean isOutputPartial() {
            return this.outputPartial;
        }

        public static Step partialOutput(Step step) {
            if (step.isInputRaw()) {
                return PARTIAL;
            }
            return INTERMEDIATE;
        }

        public static Step partialInput(Step step) {
            if (step.isOutputPartial()) {
                return INTERMEDIATE;
            }
            return FINAL;
        }
    }

    public static class GroupingSetDescriptor {
        private final List<VariableReferenceExpression> groupingKeys;
        private final int groupingSetCount;
        private final Set<Integer> globalGroupingSets;

        @JsonCreator
        public GroupingSetDescriptor(@JsonProperty(value="groupingKeys") List<VariableReferenceExpression> groupingKeys, @JsonProperty(value="groupingSetCount") int groupingSetCount, @JsonProperty(value="globalGroupingSets") Set<Integer> globalGroupingSets) {
            Objects.requireNonNull(globalGroupingSets, "globalGroupingSets is null");
            AggregationNode.checkArgument(globalGroupingSets.size() <= groupingSetCount, "list of empty global grouping sets must be no larger than grouping set count");
            Objects.requireNonNull(groupingKeys, "groupingKeys is null");
            if (groupingKeys.isEmpty()) {
                AggregationNode.checkArgument(!globalGroupingSets.isEmpty(), "no grouping keys implies at least one global grouping set, but none provided");
            }
            this.groupingKeys = Collections.unmodifiableList(new ArrayList<VariableReferenceExpression>(groupingKeys));
            this.groupingSetCount = groupingSetCount;
            this.globalGroupingSets = Collections.unmodifiableSet(new LinkedHashSet<Integer>(globalGroupingSets));
        }

        @JsonProperty
        public List<VariableReferenceExpression> getGroupingKeys() {
            return this.groupingKeys;
        }

        @JsonProperty
        public int getGroupingSetCount() {
            return this.groupingSetCount;
        }

        @JsonProperty
        public Set<Integer> getGlobalGroupingSets() {
            return this.globalGroupingSets;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupingSetDescriptor that = (GroupingSetDescriptor)o;
            return this.groupingSetCount == that.groupingSetCount && Objects.equals(this.groupingKeys, that.groupingKeys) && Objects.equals(this.globalGroupingSets, that.globalGroupingSets);
        }

        public int hashCode() {
            return Objects.hash(this.groupingKeys, this.groupingSetCount, this.globalGroupingSets);
        }
    }
}

