/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.dataformat.smile.async;

import com.facebook.presto.jdbc.internal.jackson.core.JsonParser;
import com.facebook.presto.jdbc.internal.jackson.core.JsonToken;
import com.facebook.presto.jdbc.internal.jackson.core.async.ByteArrayFeeder;
import com.facebook.presto.jdbc.internal.jackson.core.io.IOContext;
import com.facebook.presto.jdbc.internal.jackson.core.sym.ByteQuadsCanonicalizer;
import com.facebook.presto.jdbc.internal.jackson.core.util.VersionUtil;
import com.facebook.presto.jdbc.internal.jackson.dataformat.smile.SmileConstants;
import com.facebook.presto.jdbc.internal.jackson.dataformat.smile.SmileParser;
import com.facebook.presto.jdbc.internal.jackson.dataformat.smile.SmileUtil;
import com.facebook.presto.jdbc.internal.jackson.dataformat.smile.async.NonBlockingParserBase;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public class NonBlockingByteArrayParser
extends NonBlockingParserBase
implements ByteArrayFeeder {
    protected byte[] _inputBuffer = NO_BYTES;
    protected int _origBufferLen;

    public NonBlockingByteArrayParser(IOContext ctxt, int parserFeatures, int smileFeatures, ByteQuadsCanonicalizer sym) {
        super(ctxt, parserFeatures, smileFeatures, sym);
    }

    @Override
    public ByteArrayFeeder getNonBlockingInputFeeder() {
        return this;
    }

    @Override
    public final boolean needMoreInput() {
        return this._inputPtr >= this._inputEnd && !this._endOfInput;
    }

    @Override
    public void feedInput(byte[] buf, int start, int end) throws IOException {
        if (this._inputPtr < this._inputEnd) {
            this._reportError("Still have %d undecoded bytes, should not call 'feedInput'", this._inputEnd - this._inputPtr);
        }
        if (end < start) {
            this._reportError("Input end (%d) may not be before start (%d)", end, start);
        }
        if (this._endOfInput) {
            this._reportError("Already closed, can not feed more input");
        }
        this._currInputProcessed += (long)this._origBufferLen;
        this._inputBuffer = buf;
        this._inputPtr = start;
        this._inputEnd = end;
        this._origBufferLen = end - start;
    }

    @Override
    public void endOfInput() {
        this._endOfInput = true;
    }

    @Override
    public int releaseBuffered(OutputStream out) throws IOException {
        int avail = this._inputEnd - this._inputPtr;
        if (avail > 0) {
            out.write(this._inputBuffer, this._inputPtr, avail);
        }
        return avail;
    }

    @Override
    public JsonToken nextToken() throws IOException {
        if (this._inputPtr >= this._inputEnd) {
            if (this._closed) {
                return null;
            }
            if (this._endOfInput) {
                return this._eofAsNextToken();
            }
            return JsonToken.NOT_AVAILABLE;
        }
        if (this._currToken == JsonToken.NOT_AVAILABLE) {
            return this._finishToken();
        }
        this._numTypesValid = 0;
        this._binaryValue = null;
        byte ch = this._inputBuffer[this._inputPtr++];
        switch (this._majorState) {
            case 0: {
                if (58 == ch) {
                    this._majorState = 1;
                    this._minorState = 1;
                    return this._finishHeader(0);
                }
                if (SmileParser.Feature.REQUIRE_HEADER.enabledIn(this._formatFeatures)) {
                    this._reportMissingHeader(ch);
                }
                this._majorState = 1;
                return this._startValue(ch);
            }
            case 1: {
                if (58 == ch) {
                    this._minorState = 2;
                    return this._finishHeader(0);
                }
                return this._startValue(ch);
            }
            case 2: {
                return this._startFieldName(ch);
            }
            case 3: 
            case 4: {
                return this._startValue(ch);
            }
        }
        VersionUtil.throwInternal();
        return null;
    }

    protected final JsonToken _finishToken() throws IOException {
        switch (this._minorState) {
            case 1: 
            case 2: {
                return this._finishHeader(this._pending32);
            }
            case 3: {
                return this._handleSharedName(this._pending32 + (this._inputBuffer[this._inputPtr++] & 0xFF));
            }
            case 4: {
                return this._finishLongFieldName(this._inputCopyLen);
            }
            case 5: 
            case 6: {
                int fullLen = this._pending32;
                int needed = fullLen - this._inputCopyLen;
                int avail = this._inputEnd - this._inputPtr;
                if (avail >= needed) {
                    System.arraycopy(this._inputBuffer, this._inputPtr, this._inputCopy, this._inputCopyLen, needed);
                    this._inputPtr += needed;
                    String name = this._findDecodedFromSymbols(this._inputCopy, 0, fullLen);
                    if (name == null) {
                        name = this._minorState == 5 ? this._decodeASCIIText(this._inputCopy, 0, fullLen) : this._decodeShortUnicodeText(this._inputCopy, 0, fullLen);
                        name = this._addDecodedToSymbols(fullLen, name);
                    }
                    if (this._seenNames != null) {
                        if (this._seenNameCount >= this._seenNames.length) {
                            this._seenNames = this._expandSeenNames(this._seenNames);
                        }
                        this._seenNames[this._seenNameCount++] = name;
                    }
                    this._parsingContext.setCurrentName(name);
                    this._majorState = 3;
                    this._currToken = JsonToken.FIELD_NAME;
                    return this._currToken;
                }
                System.arraycopy(this._inputBuffer, this._inputPtr, this._inputCopy, this._inputCopyLen, avail);
                this._inputPtr += avail;
                this._inputCopyLen += avail;
                return JsonToken.NOT_AVAILABLE;
            }
            case 7: {
                return this._finishInt(this._pending32, this._inputCopyLen);
            }
            case 8: {
                return this._finishLong(this._pending64, this._inputCopyLen);
            }
            case 11: {
                return this._finishBigIntLen(this._pending32, this._inputCopyLen);
            }
            case 12: {
                return this._finishBigIntBody();
            }
            case 9: {
                return this._finishFloat(this._pending32, this._inputCopyLen);
            }
            case 10: {
                return this._finishDouble(this._pending64, this._inputCopyLen);
            }
            case 13: {
                return this._finishBigDecimalScale((int)this._pending64, this._inputCopyLen);
            }
            case 14: {
                return this._finishBigDecimalLen(this._pending32, this._inputCopyLen);
            }
            case 15: {
                return this._finishBigDecimalBody();
            }
            case 16: 
            case 17: {
                int fullLen = this._pending32;
                int needed = fullLen - this._inputCopyLen;
                int avail = this._inputEnd - this._inputPtr;
                if (avail >= needed) {
                    String text;
                    System.arraycopy(this._inputBuffer, this._inputPtr, this._inputCopy, this._inputCopyLen, needed);
                    this._inputPtr += needed;
                    String string = text = this._minorState == 5 ? this._decodeASCIIText(this._inputCopy, 0, fullLen) : this._decodeShortUnicodeText(this._inputCopy, 0, fullLen);
                    if (this._seenStringValueCount >= 0) {
                        this._addSeenStringValue(text);
                    }
                    return this._valueComplete(JsonToken.VALUE_STRING);
                }
                System.arraycopy(this._inputBuffer, this._inputPtr, this._inputCopy, this._inputCopyLen, avail);
                this._inputPtr += avail;
                this._inputCopyLen += avail;
                return JsonToken.NOT_AVAILABLE;
            }
            case 18: {
                return this._finishLongASCII();
            }
            case 19: {
                return this._finishLongUnicode();
            }
            case 20: {
                return this._handleSharedString(this._pending32 + (this._inputBuffer[this._inputPtr++] & 0xFF));
            }
            case 21: {
                return this._finishRawBinaryLen(this._pending32, this._inputCopyLen);
            }
            case 22: {
                return this._finishRawBinaryBody();
            }
            case 23: {
                return this._finish7BitBinaryLen(this._pending32, this._inputCopyLen);
            }
            case 24: {
                return this._finish7BitBinaryBody();
            }
        }
        throw new IllegalStateException("Illegal state when trying to complete token: majorState=" + this._majorState);
    }

    protected JsonToken _finishHeader(int state) throws IOException {
        int ch = 0;
        String errorDesc = null;
        switch (state) {
            case 0: {
                if (this._inputPtr >= this._inputEnd) {
                    this._pending32 = state;
                    this._currToken = JsonToken.NOT_AVAILABLE;
                    return this._currToken;
                }
                if ((ch = this._inputBuffer[this._inputPtr++]) != 41) {
                    errorDesc = "Malformed content: signature not valid, starts with 0x3a but followed by 0x%s, not 0x29";
                    break;
                }
                state = 1;
            }
            case 1: {
                if (this._inputPtr >= this._inputEnd) {
                    this._pending32 = state;
                    this._currToken = JsonToken.NOT_AVAILABLE;
                    return this._currToken;
                }
                if ((ch = this._inputBuffer[this._inputPtr++]) != 10) {
                    errorDesc = "Malformed content: signature not valid, starts with 0x3a, 0x29, but followed by 0x%s not 0x0A";
                    break;
                }
                state = 2;
            }
            case 2: {
                int versionBits;
                if (this._inputPtr >= this._inputEnd) {
                    this._pending32 = state;
                    this._currToken = JsonToken.NOT_AVAILABLE;
                    return this._currToken;
                }
                if ((versionBits = (ch = this._inputBuffer[this._inputPtr++]) >> 4 & 0xF) != 0) {
                    this._reportError("Header version number bits (0x%s) indicate unrecognized version; only 0x0 handled by parser", Integer.toHexString(versionBits));
                }
                if ((ch & 1) == 0) {
                    this._seenNames = null;
                    this._seenNameCount = -1;
                }
                if ((ch & 2) != 0) {
                    this._seenStringValues = NO_STRINGS;
                    this._seenStringValueCount = 0;
                }
                this._mayContainRawBinary = (ch & 4) != 0;
                this._majorState = 1;
                this._currToken = null;
                if (this._minorState == 2) {
                    return null;
                }
                return this.nextToken();
            }
        }
        this._reportError(errorDesc, Integer.toHexString(ch));
        return null;
    }

    private final JsonToken _startValue(int ch) throws IOException {
        block0 : switch (ch >> 5 & 7) {
            case 0: {
                if (ch == 0) {
                    this._reportError("Invalid token byte 0x00");
                }
                return this._handleSharedString(ch - 1);
            }
            case 1: {
                this._numTypesValid = 0;
                switch (ch & 0x1F) {
                    case 0: {
                        this._textBuffer.resetWithEmpty();
                        return this._valueComplete(JsonToken.VALUE_STRING);
                    }
                    case 1: {
                        return this._valueComplete(JsonToken.VALUE_NULL);
                    }
                    case 2: {
                        return this._valueComplete(JsonToken.VALUE_FALSE);
                    }
                    case 3: {
                        return this._valueComplete(JsonToken.VALUE_TRUE);
                    }
                    case 4: {
                        return this._startInt();
                    }
                    case 5: {
                        return this._startLong();
                    }
                    case 6: {
                        return this._startBigInt();
                    }
                    case 7: {
                        break block0;
                    }
                    case 8: {
                        return this._startFloat();
                    }
                    case 9: {
                        return this._startDouble();
                    }
                    case 10: {
                        return this._startBigDecimal();
                    }
                    case 11: {
                        break block0;
                    }
                    case 26: {
                        break block0;
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                return this._startShortASCII(1 + (ch & 0x3F));
            }
            case 4: 
            case 5: {
                return this._startShortUnicode(2 + (ch & 0x3F));
            }
            case 6: {
                this._numberInt = SmileUtil.zigzagDecode(ch & 0x1F);
                this._numTypesValid = 1;
                this._numberType = JsonParser.NumberType.INT;
                return this._valueComplete(JsonToken.VALUE_NUMBER_INT);
            }
            case 7: {
                switch (ch & 0x1F) {
                    case 0: {
                        return this._startLongASCII();
                    }
                    case 4: {
                        return this._startLongUnicode();
                    }
                    case 8: {
                        return this._start7BitBinary();
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        ch = (ch & 3) << 8;
                        if (this._inputPtr < this._inputEnd) {
                            return this._handleSharedString(ch + (this._inputBuffer[this._inputPtr++] & 0xFF));
                        }
                        this._pending32 = ch;
                        this._minorState = 20;
                        this._currToken = JsonToken.NOT_AVAILABLE;
                        return this._currToken;
                    }
                    case 24: {
                        return this._startArrayScope();
                    }
                    case 25: {
                        return this._closeArrayScope();
                    }
                    case 26: {
                        return this._startObjectScope();
                    }
                    case 27: {
                        this._reportError("Invalid type marker byte 0xFB in value mode (would be END_OBJECT in key mode)");
                    }
                    case 29: {
                        return this._startRawBinary();
                    }
                    case 31: {
                        this._currToken = null;
                        return null;
                    }
                }
            }
        }
        this._reportError("Invalid type marker byte 0x%02x for expected value token", ch & 0xFF);
        return null;
    }

    protected final JsonToken _startFieldName(int ch) throws IOException {
        switch (ch >> 6 & 3) {
            case 0: {
                switch (ch) {
                    case 32: {
                        this._parsingContext.setCurrentName("");
                        this._majorState = 3;
                        this._currToken = JsonToken.FIELD_NAME;
                        return this._currToken;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: {
                        if (this._inputPtr < this._inputEnd) {
                            return this._handleSharedName(((ch & 3) << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF));
                        }
                        this._minorState = 3;
                        this._pending32 = (ch & 3) << 8;
                        this._currToken = JsonToken.NOT_AVAILABLE;
                        return this._currToken;
                    }
                    case 52: {
                        return this._finishLongFieldName(0);
                    }
                }
                break;
            }
            case 1: {
                return this._handleSharedName(ch & 0x3F);
            }
            case 2: {
                int len = 1 + (ch & 0x3F);
                int inputPtr = this._inputPtr;
                int left = this._inputEnd - inputPtr;
                if (len <= left) {
                    this._inputPtr = inputPtr + len;
                    String name = this._findDecodedFromSymbols(this._inputBuffer, inputPtr, len);
                    if (name == null) {
                        name = this._decodeASCIIText(this._inputBuffer, inputPtr, len);
                        name = this._addDecodedToSymbols(len, name);
                    }
                    if (this._seenNames != null) {
                        if (this._seenNameCount >= this._seenNames.length) {
                            this._seenNames = this._expandSeenNames(this._seenNames);
                        }
                        this._seenNames[this._seenNameCount++] = name;
                    }
                    this._parsingContext.setCurrentName(name);
                    this._majorState = 3;
                    this._currToken = JsonToken.FIELD_NAME;
                    return this._currToken;
                }
                this._pending32 = len;
                this._inputCopyLen = left;
                if (left > 0) {
                    this._inputPtr = inputPtr + left;
                    System.arraycopy(this._inputBuffer, inputPtr, this._inputCopy, 0, left);
                }
                this._minorState = 5;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            case 3: {
                if ((ch &= 0x3F) > 55) {
                    if (ch != 59) break;
                    return this._closeObjectScope();
                }
                int len = ch + 2;
                int inputPtr = this._inputPtr;
                int left = this._inputEnd - inputPtr;
                if (len <= left) {
                    this._inputPtr = inputPtr + len;
                    String name = this._findDecodedFromSymbols(this._inputBuffer, inputPtr, len);
                    if (name == null) {
                        name = this._decodeShortUnicodeText(this._inputBuffer, inputPtr, len);
                        name = this._addDecodedToSymbols(len, name);
                    }
                    if (this._seenNames != null) {
                        if (this._seenNameCount >= this._seenNames.length) {
                            this._seenNames = this._expandSeenNames(this._seenNames);
                        }
                        this._seenNames[this._seenNameCount++] = name;
                    }
                    this._parsingContext.setCurrentName(name);
                    this._majorState = 3;
                    this._currToken = JsonToken.FIELD_NAME;
                    return this._currToken;
                }
                this._pending32 = len;
                this._inputCopyLen = left;
                if (left > 0) {
                    this._inputPtr = inputPtr + left;
                    System.arraycopy(this._inputBuffer, inputPtr, this._inputCopy, 0, left);
                }
                this._minorState = 6;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
        }
        this._reportError("Invalid type marker byte 0x%02x for expected field name (or END_OBJECT marker)", ch & 0xFF);
        return null;
    }

    private final JsonToken _finishLongFieldName(int outPtr) throws IOException {
        String name;
        int in;
        byte[] srcBuffer = this._inputBuffer;
        byte[] copyBuffer = this._inputCopy;
        int srcPtr = this._inputPtr;
        block0: while (true) {
            int max = Math.min(this._inputEnd - srcPtr, copyBuffer.length - outPtr);
            int inputEnd = srcPtr + max;
            while (srcPtr < inputEnd) {
                byte b;
                if ((b = srcBuffer[srcPtr++]) == -4) break block0;
                copyBuffer[outPtr++] = b;
            }
            if (srcPtr == this._inputEnd) {
                this._inputPtr = srcPtr;
                this._minorState = 4;
                this._inputCopyLen = outPtr;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            int oldLen = copyBuffer.length;
            int incr = Math.min(64000, oldLen >> 1);
            this._inputCopy = copyBuffer = Arrays.copyOf(this._inputCopy, oldLen + incr);
        }
        this._inputPtr = srcPtr;
        int[] quads = this._quadBuffer;
        int qlen = outPtr + 3 >> 2;
        if (quads.length < qlen) {
            this._quadBuffer = quads = Arrays.copyOf(quads, qlen + 16);
        }
        int quadCount = 0;
        int inEnd = outPtr & 0xFFFFFFFC;
        for (in = 0; in < inEnd; in += 4) {
            int q = copyBuffer[in] << 24 | (copyBuffer[in + 1] & 0xFF) << 16 | (copyBuffer[in + 2] & 0xFF) << 8 | copyBuffer[in + 3] & 0xFF;
            quads[quadCount++] = q;
        }
        if (in < outPtr) {
            int q = copyBuffer[in++] & 0xFF;
            if (in < outPtr) {
                q = q << 8 | copyBuffer[in++] & 0xFF;
                if (in < outPtr) {
                    q = q << 8 | copyBuffer[in++] & 0xFF;
                }
            }
            quads[quadCount++] = q;
        }
        if ((name = this._symbols.findName(quads, quadCount)) == null) {
            name = this._decodeLongUnicodeName(copyBuffer, 0, outPtr);
        }
        if (this._seenNames != null) {
            if (this._seenNameCount >= this._seenNames.length) {
                this._seenNames = this._expandSeenNames(this._seenNames);
            }
            this._seenNames[this._seenNameCount++] = name;
        }
        this._parsingContext.setCurrentName(name);
        this._majorState = 3;
        this._currToken = JsonToken.FIELD_NAME;
        return this._currToken;
    }

    private final JsonToken _startShortASCII(int len) throws IOException {
        int inputPtr = this._inputPtr;
        int left = this._inputEnd - inputPtr;
        if (len <= left) {
            this._inputPtr = inputPtr + len;
            String text = this._decodeASCIIText(this._inputBuffer, inputPtr, len);
            if (this._seenStringValueCount >= 0) {
                this._addSeenStringValue(text);
            }
            return this._valueComplete(JsonToken.VALUE_STRING);
        }
        this._pending32 = len;
        this._inputCopyLen = left;
        if (left > 0) {
            this._inputPtr = inputPtr + left;
            System.arraycopy(this._inputBuffer, inputPtr, this._inputCopy, 0, left);
        }
        this._minorState = 16;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _startShortUnicode(int len) throws IOException {
        int inPtr = this._inputPtr;
        int left = this._inputEnd - inPtr;
        if (len <= left) {
            this._inputPtr = inPtr + len;
            String text = this._decodeShortUnicodeText(this._inputBuffer, inPtr, len);
            if (this._seenStringValueCount >= 0) {
                this._addSeenStringValue(text);
            }
            return this._valueComplete(JsonToken.VALUE_STRING);
        }
        this._pending32 = len;
        this._inputCopyLen = left;
        if (left > 0) {
            System.arraycopy(this._inputBuffer, inPtr, this._inputCopy, 0, left);
            this._inputPtr = inPtr + left;
        }
        this._minorState = 17;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _startLongASCII() throws IOException {
        int outPtr = 0;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        while (this._inputPtr < this._inputEnd) {
            int inPtr = this._inputPtr;
            int left = this._inputEnd - inPtr;
            if (outPtr >= outBuf.length) {
                outBuf = this._textBuffer.finishCurrentSegment();
                outPtr = 0;
            }
            left = Math.min(left, outBuf.length - outPtr);
            do {
                byte b;
                if ((b = this._inputBuffer[inPtr++]) == -4) {
                    this._inputPtr = inPtr;
                    this._textBuffer.setCurrentLength(outPtr);
                    return this._valueComplete(JsonToken.VALUE_STRING);
                }
                outBuf[outPtr++] = (char)b;
            } while (--left > 0);
            this._inputPtr = inPtr;
        }
        this._textBuffer.setCurrentLength(outPtr);
        this._minorState = 18;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _finishLongASCII() throws IOException {
        char[] outBuf = this._textBuffer.getBufferWithoutReset();
        int outPtr = this._textBuffer.getCurrentSegmentSize();
        while (this._inputPtr < this._inputEnd) {
            int inPtr = this._inputPtr;
            int left = this._inputEnd - inPtr;
            if (outPtr >= outBuf.length) {
                outBuf = this._textBuffer.finishCurrentSegment();
                outPtr = 0;
            }
            left = Math.min(left, outBuf.length - outPtr);
            do {
                byte b;
                if ((b = this._inputBuffer[inPtr++]) == -4) {
                    this._inputPtr = inPtr;
                    this._textBuffer.setCurrentLength(outPtr);
                    return this._valueComplete(JsonToken.VALUE_STRING);
                }
                outBuf[outPtr++] = (char)b;
            } while (--left > 0);
            this._inputPtr = inPtr;
        }
        this._textBuffer.setCurrentLength(outPtr);
        return JsonToken.NOT_AVAILABLE;
    }

    protected final JsonToken _startLongUnicode() throws IOException {
        int outPtr;
        block19: {
            outPtr = 0;
            char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
            int[] codes = SmileConstants.sUtf8UnitLengths;
            byte[] inputBuffer = this._inputBuffer;
            while (true) {
                int c;
                int ptr;
                block18: {
                    int max;
                    int max2;
                    ptr = this._inputPtr;
                    if (outPtr >= outBuf.length) {
                        outBuf = this._textBuffer.finishCurrentSegment();
                        outPtr = 0;
                    }
                    if ((max2 = ptr + (outBuf.length - outPtr)) < (max = this._inputEnd)) {
                        max = max2;
                    }
                    while (ptr < max) {
                        if (codes[c = inputBuffer[ptr++] & 0xFF] == 0) {
                            outBuf[outPtr++] = (char)c;
                            continue;
                        }
                        break block18;
                    }
                    this._inputPtr = ptr;
                    if (ptr < this._inputEnd) continue;
                    this._inputCopyLen = 0;
                    break block19;
                }
                this._inputPtr = ptr;
                if (c == 252) {
                    this._textBuffer.setCurrentLength(outPtr);
                    return this._valueComplete(JsonToken.VALUE_STRING);
                }
                if (this._inputPtr >= this._inputEnd) {
                    this._pending32 = c;
                    this._inputCopyLen = 1;
                    break block19;
                }
                byte d = this._inputBuffer[this._inputPtr++];
                switch (codes[c]) {
                    case 1: {
                        c = this._decodeUTF8_2(c, d);
                        break;
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pending32 = c;
                            this._inputCopy[0] = d;
                            this._inputCopyLen = 2;
                            break block19;
                        }
                        c = this._decodeUTF8_3(c, d, this._inputBuffer[this._inputPtr++]);
                        break;
                    }
                    case 3: {
                        if (this._inputPtr + 1 >= this._inputEnd) {
                            this._pending32 = c;
                            this._inputCopy[0] = d;
                            if (this._inputPtr >= this._inputEnd) {
                                this._inputCopyLen = 2;
                            } else {
                                this._inputCopy[1] = this._inputBuffer[this._inputPtr++];
                                this._inputCopyLen = 3;
                            }
                            break block19;
                        }
                        c = this._decodeUTF8_4(c, d, this._inputBuffer[this._inputPtr++], this._inputBuffer[this._inputPtr++]);
                        outBuf[outPtr++] = (char)(0xD800 | c >> 10);
                        if (outPtr >= outBuf.length) {
                            outBuf = this._textBuffer.finishCurrentSegment();
                            outPtr = 0;
                        }
                        c = 0xDC00 | c & 0x3FF;
                        break;
                    }
                    default: {
                        this._reportInvalidInitial(c);
                    }
                }
                if (outPtr >= outBuf.length) {
                    outBuf = this._textBuffer.finishCurrentSegment();
                    outPtr = 0;
                }
                outBuf[outPtr++] = (char)c;
                if (this._inputPtr >= this._inputEnd) break;
            }
            this._inputCopyLen = 0;
        }
        this._textBuffer.setCurrentLength(outPtr);
        this._minorState = 19;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _finishLongUnicode() throws IOException {
        if (this._inputCopyLen > 0 && !this._finishPartialUnicodeChar()) {
            return JsonToken.NOT_AVAILABLE;
        }
        int[] codes = SmileConstants.sUtf8UnitLengths;
        byte[] inputBuffer = this._inputBuffer;
        char[] outBuf = this._textBuffer.getBufferWithoutReset();
        int outPtr = this._textBuffer.getCurrentSegmentSize();
        block5: while (true) {
            int c;
            int ptr;
            block19: {
                int max;
                int max2;
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this._inputCopyLen = 0;
                    break;
                }
                if (outPtr >= outBuf.length) {
                    outBuf = this._textBuffer.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outBuf.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (codes[c = inputBuffer[ptr++] & 0xFF] == 0) {
                        outBuf[outPtr++] = (char)c;
                        continue;
                    }
                    break block19;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            if (c == 252) {
                this._textBuffer.setCurrentLength(outPtr);
                return this._valueComplete(JsonToken.VALUE_STRING);
            }
            if (this._inputPtr >= this._inputEnd) {
                this._pending32 = c;
                this._inputCopyLen = 1;
                break;
            }
            byte d = this._inputBuffer[this._inputPtr++];
            switch (codes[c]) {
                case 1: {
                    c = this._decodeUTF8_2(c, d);
                    break;
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pending32 = c;
                        this._inputCopy[0] = d;
                        this._inputCopyLen = 2;
                        break block5;
                    }
                    c = this._decodeUTF8_3(c, d, this._inputBuffer[this._inputPtr++]);
                    break;
                }
                case 3: {
                    if (this._inputPtr + 1 >= this._inputEnd) {
                        this._pending32 = c;
                        this._inputCopy[0] = d;
                        if (this._inputPtr >= this._inputEnd) {
                            this._inputCopyLen = 2;
                            break block5;
                        }
                        this._inputCopy[1] = this._inputBuffer[this._inputPtr++];
                        this._inputCopyLen = 3;
                        break block5;
                    }
                    c = this._decodeUTF8_4(c, d, this._inputBuffer[this._inputPtr++], this._inputBuffer[this._inputPtr++]);
                    outBuf[outPtr++] = (char)(0xD800 | c >> 10);
                    if (outPtr >= outBuf.length) {
                        outBuf = this._textBuffer.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 0xDC00 | c & 0x3FF;
                    break;
                }
                default: {
                    this._reportInvalidInitial(c);
                }
            }
            if (outPtr >= outBuf.length) {
                outBuf = this._textBuffer.finishCurrentSegment();
                outPtr = 0;
            }
            outBuf[outPtr++] = (char)c;
        }
        this._textBuffer.setCurrentLength(outPtr);
        return JsonToken.NOT_AVAILABLE;
    }

    private final boolean _finishPartialUnicodeChar() throws IOException {
        int c;
        int[] codes = SmileConstants.sUtf8UnitLengths;
        byte next = this._inputBuffer[this._inputPtr++];
        switch (codes[this._pending32]) {
            case 1: {
                c = this._decodeUTF8_2(this._pending32, next);
                break;
            }
            case 2: {
                if (this._inputCopyLen == 1) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._inputCopy[0] = next;
                        this._inputCopyLen = 2;
                        return false;
                    }
                    c = this._decodeUTF8_3(this._pending32, next, this._inputBuffer[this._inputPtr++]);
                    break;
                }
                c = this._decodeUTF8_3(this._pending32, this._inputCopy[0], next);
                break;
            }
            case 3: {
                switch (this._inputCopyLen) {
                    case 1: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._inputCopy[0] = next;
                            this._inputCopyLen = 2;
                            return false;
                        }
                        byte i3 = this._inputBuffer[this._inputPtr++];
                        if (this._inputPtr >= this._inputEnd) {
                            this._inputCopy[0] = next;
                            this._inputCopy[1] = i3;
                            this._inputCopyLen = 3;
                            return false;
                        }
                        c = this._decodeUTF8_4(this._pending32, next, i3, this._inputBuffer[this._inputPtr++]);
                        break;
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._inputCopy[1] = next;
                            this._inputCopyLen = 3;
                            return false;
                        }
                        c = this._decodeUTF8_4(this._pending32, this._inputCopy[0], next, this._inputBuffer[this._inputPtr++]);
                        break;
                    }
                    default: {
                        c = this._decodeUTF8_4(this._pending32, this._inputCopy[0], this._inputCopy[1], next);
                    }
                }
                this._textBuffer.append((char)(0xD800 | c >> 10));
                c = 0xDC00 | c & 0x3FF;
                break;
            }
            default: {
                this._reportInvalidInitial(this._pending32);
                c = 0;
            }
        }
        this._inputCopyLen = 0;
        this._textBuffer.append((char)c);
        return true;
    }

    private final int _decodeUTF8_2(int c, int d) throws IOException {
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        return (c & 0x1F) << 6 | d & 0x3F;
    }

    private final int _decodeUTF8_3(int c, int d, int e) throws IOException {
        c &= 0xF;
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        if ((e & 0xC0) != 128) {
            this._reportInvalidOther(e & 0xFF, this._inputPtr);
        }
        return c << 6 | e & 0x3F;
    }

    private final int _decodeUTF8_4(int c, int d, int e, int f) throws IOException {
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = (c & 7) << 6 | d & 0x3F;
        if ((e & 0xC0) != 128) {
            this._reportInvalidOther(e & 0xFF, this._inputPtr);
        }
        c = c << 6 | e & 0x3F;
        if ((f & 0xC0) != 128) {
            this._reportInvalidOther(f & 0xFF, this._inputPtr);
        }
        return (c << 6 | f & 0x3F) - 65536;
    }

    private final JsonToken _startInt() throws IOException {
        if (this._inputPtr + 5 > this._inputEnd) {
            return this._finishInt(0, 0);
        }
        int value = this._decodeVInt();
        this._numberInt = SmileUtil.zigzagDecode(value);
        this._numTypesValid = 1;
        this._numberType = JsonParser.NumberType.INT;
        return this._valueComplete(JsonToken.VALUE_NUMBER_INT);
    }

    private final JsonToken _finishInt(int value, int bytesRead) throws IOException {
        while (this._inputPtr < this._inputEnd) {
            byte b;
            if ((b = this._inputBuffer[this._inputPtr++]) < 0) {
                value = value << 6 | b & 0x3F;
                this._numberInt = SmileUtil.zigzagDecode(value);
                this._numTypesValid = 1;
                this._numberType = JsonParser.NumberType.INT;
                return this._valueComplete(JsonToken.VALUE_NUMBER_INT);
            }
            if (++bytesRead >= 5) {
                this._reportError("Corrupt input; 32-bit VInt extends beyond 5 data bytes");
            }
            value = value << 7 | b;
        }
        this._minorState = 7;
        this._pending32 = value;
        this._inputCopyLen = bytesRead;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _startLong() throws IOException {
        int ptr = this._inputPtr;
        int maxEnd = ptr + 11;
        if (maxEnd >= this._inputEnd) {
            return this._finishLong(0L, 0);
        }
        int i = this._inputBuffer[ptr++];
        i = (i << 7) + this._inputBuffer[ptr++];
        i = (i << 7) + this._inputBuffer[ptr++];
        i = (i << 7) + this._inputBuffer[ptr++];
        long l = i;
        while (true) {
            byte value;
            if ((value = this._inputBuffer[ptr++]) < 0) {
                l = (l << 6) + (long)(value & 0x3F);
                this._inputPtr = ptr;
                this._numberLong = SmileUtil.zigzagDecode(l);
                this._numTypesValid = 2;
                this._numberType = JsonParser.NumberType.LONG;
                return this._valueComplete(JsonToken.VALUE_NUMBER_INT);
            }
            l = (l << 7) + (long)value;
            if (ptr < maxEnd) continue;
            this._reportError("Corrupt input; 64-bit VInt extends beyond 11 data bytes");
        }
    }

    private final JsonToken _finishLong(long value, int bytesRead) throws IOException {
        while (this._inputPtr < this._inputEnd) {
            byte b;
            if ((b = this._inputBuffer[this._inputPtr++]) < 0) {
                value = value << 6 | (long)(b & 0x3F);
                this._numberLong = SmileUtil.zigzagDecode(value);
                this._numTypesValid = 2;
                this._numberType = JsonParser.NumberType.LONG;
                return this._valueComplete(JsonToken.VALUE_NUMBER_INT);
            }
            if (++bytesRead >= 11) {
                this._reportError("Corrupt input; 64-bit VInt extends beyond 5 data bytes");
            }
            value = value << 7 | (long)b;
        }
        this._minorState = 8;
        this._pending64 = value;
        this._inputCopyLen = bytesRead;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _startBigInt() throws IOException {
        this._initByteArrayBuilder();
        if (this._inputPtr + 5 > this._inputEnd) {
            return this._finishBigIntLen(0, 0);
        }
        this._pending32 = this._decodeVInt();
        this._inputCopyLen = 0;
        return this._finishBigIntBody();
    }

    private final JsonToken _finishBigIntLen(int value, int bytesRead) throws IOException {
        while (this._inputPtr < this._inputEnd) {
            byte b;
            if ((b = this._inputBuffer[this._inputPtr++]) < 0) {
                this._pending32 = value << 6 | b & 0x3F;
                this._inputCopyLen = 0;
                return this._finishBigIntBody();
            }
            if (++bytesRead >= 5) {
                this._reportError("Corrupt input; 32-bit VInt extends beyond 5 data bytes");
            }
            value = value << 7 | b;
        }
        this._minorState = 11;
        this._pending32 = value;
        this._inputCopyLen = bytesRead;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _finishBigIntBody() throws IOException {
        if (this._decode7BitEncoded()) {
            this._numberBigInt = new BigInteger(this._byteArrayBuilder.toByteArray());
            this._numberType = JsonParser.NumberType.BIG_INTEGER;
            this._numTypesValid = 4;
            return this._valueComplete(JsonToken.VALUE_NUMBER_INT);
        }
        this._minorState = 12;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    protected final JsonToken _startFloat() throws IOException {
        int ptr = this._inputPtr;
        if (ptr + 5 > this._inputEnd) {
            return this._finishFloat(0, 0);
        }
        int i = this._fourBytesToInt(ptr);
        ptr += 4;
        i = (i << 7) + this._inputBuffer[ptr++];
        this._inputPtr = ptr;
        this._numberFloat = Float.intBitsToFloat(i);
        this._numTypesValid = 32;
        this._numberType = JsonParser.NumberType.FLOAT;
        return this._valueComplete(JsonToken.VALUE_NUMBER_FLOAT);
    }

    protected final JsonToken _finishFloat(int value, int bytesRead) throws IOException {
        while (this._inputPtr < this._inputEnd) {
            value = (value << 7) + this._inputBuffer[this._inputPtr++];
            if (++bytesRead != 5) continue;
            this._numberFloat = Float.intBitsToFloat(value);
            this._numTypesValid = 32;
            this._numberType = JsonParser.NumberType.FLOAT;
            return this._valueComplete(JsonToken.VALUE_NUMBER_FLOAT);
        }
        this._minorState = 9;
        this._pending32 = value;
        this._inputCopyLen = bytesRead;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    protected final JsonToken _startDouble() throws IOException {
        int ptr = this._inputPtr;
        if (ptr + 10 > this._inputEnd) {
            return this._finishDouble(0L, 0);
        }
        long hi = this._fourBytesToInt(ptr);
        long value = (hi << 28) + (long)this._fourBytesToInt(ptr += 4);
        ptr += 4;
        value = (value << 7) + (long)this._inputBuffer[ptr++];
        value = (value << 7) + (long)this._inputBuffer[ptr++];
        this._inputPtr = ptr;
        this._numberDouble = Double.longBitsToDouble(value);
        this._numTypesValid = 8;
        this._numberType = JsonParser.NumberType.DOUBLE;
        return this._valueComplete(JsonToken.VALUE_NUMBER_FLOAT);
    }

    protected final JsonToken _finishDouble(long value, int bytesRead) throws IOException {
        while (this._inputPtr < this._inputEnd) {
            value = (value << 7) + (long)this._inputBuffer[this._inputPtr++];
            if (++bytesRead != 10) continue;
            this._numberDouble = Double.longBitsToDouble(value);
            this._numTypesValid = 8;
            this._numberType = JsonParser.NumberType.DOUBLE;
            return this._valueComplete(JsonToken.VALUE_NUMBER_FLOAT);
        }
        this._minorState = 10;
        this._pending64 = value;
        this._inputCopyLen = bytesRead;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _startBigDecimal() throws IOException {
        this._initByteArrayBuilder();
        if (this._inputPtr + 5 > this._inputEnd) {
            return this._finishBigDecimalScale(0, 0);
        }
        this._pending64 = this._decodeVInt();
        return this._finishBigDecimalLen(0, 0);
    }

    private final JsonToken _finishBigDecimalScale(int value, int bytesRead) throws IOException {
        while (this._inputPtr < this._inputEnd) {
            byte b;
            if ((b = this._inputBuffer[this._inputPtr++]) < 0) {
                value = value << 6 | b & 0x3F;
                this._pending64 = value;
                return this._finishBigDecimalLen(0, 0);
            }
            if (++bytesRead >= 5) {
                this._reportError("Corrupt input; 32-bit VInt extends beyond 5 data bytes");
            }
            value = value << 7 | b;
        }
        this._minorState = 13;
        this._pending64 = value;
        this._inputCopyLen = bytesRead;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _finishBigDecimalLen(int value, int bytesRead) throws IOException {
        while (this._inputPtr < this._inputEnd) {
            byte b;
            if ((b = this._inputBuffer[this._inputPtr++]) < 0) {
                this._pending32 = value << 6 | b & 0x3F;
                this._inputCopyLen = 0;
                return this._finishBigDecimalBody();
            }
            if (++bytesRead >= 5) {
                this._reportError("Corrupt input; 32-bit VInt extends beyond 5 data bytes");
            }
            value = value << 7 | b;
        }
        this._minorState = 14;
        this._pending32 = value;
        this._inputCopyLen = bytesRead;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _finishBigDecimalBody() throws IOException {
        if (this._decode7BitEncoded()) {
            int scale = SmileUtil.zigzagDecode((int)this._pending64);
            BigInteger bigInt = new BigInteger(this._byteArrayBuilder.toByteArray());
            this._numberBigDecimal = new BigDecimal(bigInt, scale);
            this._numberType = JsonParser.NumberType.BIG_DECIMAL;
            this._numTypesValid = 16;
            return this._valueComplete(JsonToken.VALUE_NUMBER_FLOAT);
        }
        this._minorState = 15;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    protected final JsonToken _startRawBinary() throws IOException {
        if (this._inputPtr + 5 > this._inputEnd) {
            return this._finishRawBinaryLen(0, 0);
        }
        int len = this._decodeVInt();
        this._binaryValue = new byte[len];
        this._pending32 = len;
        this._inputCopyLen = 0;
        return this._finishRawBinaryBody();
    }

    private final JsonToken _finishRawBinaryLen(int value, int bytesRead) throws IOException {
        while (this._inputPtr < this._inputEnd) {
            byte b;
            if ((b = this._inputBuffer[this._inputPtr++]) < 0) {
                int len = value << 6 | b & 0x3F;
                this._binaryValue = new byte[len];
                this._pending32 = len;
                this._inputCopyLen = 0;
                return this._finishRawBinaryBody();
            }
            if (++bytesRead >= 5) {
                this._reportError("Corrupt input; 32-bit VInt extends beyond 5 data bytes");
            }
            value = value << 7 | b;
        }
        this._minorState = 21;
        this._pending32 = value;
        this._inputCopyLen = bytesRead;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _finishRawBinaryBody() throws IOException {
        int avail = this._inputEnd - this._inputPtr;
        int totalLen = this._pending32;
        int offset = this._inputCopyLen;
        int needed = totalLen - offset;
        if (avail >= needed) {
            System.arraycopy(this._inputBuffer, this._inputPtr, this._binaryValue, offset, needed);
            this._inputPtr += needed;
            return this._valueComplete(JsonToken.VALUE_EMBEDDED_OBJECT);
        }
        if (avail > 0) {
            System.arraycopy(this._inputBuffer, this._inputPtr, this._binaryValue, offset, avail);
            this._inputPtr += avail;
        }
        this._pending32 = totalLen;
        this._inputCopyLen = offset + avail;
        this._minorState = 22;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _start7BitBinary() throws IOException {
        this._initByteArrayBuilder();
        if (this._inputPtr + 5 > this._inputEnd) {
            return this._finish7BitBinaryLen(0, 0);
        }
        this._pending32 = this._decodeVInt();
        this._inputCopyLen = 0;
        return this._finish7BitBinaryBody();
    }

    private final JsonToken _finish7BitBinaryLen(int value, int bytesRead) throws IOException {
        while (this._inputPtr < this._inputEnd) {
            byte b;
            if ((b = this._inputBuffer[this._inputPtr++]) < 0) {
                this._pending32 = value << 6 | b & 0x3F;
                this._inputCopyLen = 0;
                return this._finish7BitBinaryBody();
            }
            if (++bytesRead >= 5) {
                this._reportError("Corrupt input; 32-bit VInt extends beyond 5 data bytes");
            }
            value = value << 7 | b;
        }
        this._minorState = 23;
        this._pending32 = value;
        this._inputCopyLen = bytesRead;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _finish7BitBinaryBody() throws IOException {
        if (this._decode7BitEncoded()) {
            this._binaryValue = this._byteArrayBuilder.toByteArray();
            return this._valueComplete(JsonToken.VALUE_EMBEDDED_OBJECT);
        }
        this._minorState = 24;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final String _decodeASCIIText(byte[] inBuf, int inPtr, int len) throws IOException {
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int outPtr = 0;
        int inEnd = inPtr + len - 3;
        while (inPtr < inEnd) {
            outBuf[outPtr++] = (char)inBuf[inPtr++];
            outBuf[outPtr++] = (char)inBuf[inPtr++];
            outBuf[outPtr++] = (char)inBuf[inPtr++];
            outBuf[outPtr++] = (char)inBuf[inPtr++];
        }
        int left = len & 3;
        if (left > 0) {
            outBuf[outPtr++] = (char)inBuf[inPtr++];
            if (left > 1) {
                outBuf[outPtr++] = (char)inBuf[inPtr++];
                if (left > 2) {
                    outBuf[outPtr++] = (char)inBuf[inPtr++];
                }
            }
        }
        this._textBuffer.setCurrentLength(len);
        return this._textBuffer.contentsAsString();
    }

    private final String _decodeShortUnicodeText(byte[] inBuf, int inPtr, int len) throws IOException {
        int outPtr = 0;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int[] codes = SmileConstants.sUtf8UnitLengths;
        int end = inPtr + len;
        while (inPtr < end) {
            int i;
            int code;
            if ((code = codes[i = inBuf[inPtr++] & 0xFF]) != 0) {
                switch (code) {
                    case 1: {
                        i = (i & 0x1F) << 6 | inBuf[inPtr++] & 0x3F;
                        break;
                    }
                    case 2: {
                        i = (i & 0xF) << 12 | (inBuf[inPtr++] & 0x3F) << 6 | inBuf[inPtr++] & 0x3F;
                        break;
                    }
                    case 3: {
                        i = (i & 7) << 18 | (inBuf[inPtr++] & 0x3F) << 12 | (inBuf[inPtr++] & 0x3F) << 6 | inBuf[inPtr++] & 0x3F;
                        outBuf[outPtr++] = (char)(0xD800 | (i -= 65536) >> 10);
                        i = 0xDC00 | i & 0x3FF;
                        break;
                    }
                    default: {
                        this._reportError("Invalid byte 0x%02x in short Unicode text block (offset %d)", i & 0xFF, inPtr);
                    }
                }
            }
            outBuf[outPtr++] = (char)i;
        }
        this._textBuffer.setCurrentLength(outPtr);
        return this._textBuffer.contentsAsString();
    }

    private final String _decodeLongUnicodeName(byte[] inBuf, int inPtr, int len) throws IOException {
        int outPtr = 0;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int[] codes = SmileConstants.sUtf8UnitLengths;
        int estSlack = outBuf.length - len - 8;
        int end = inPtr + len;
        while (inPtr < end) {
            int i;
            int code;
            if ((code = codes[i = inBuf[inPtr++] & 0xFF]) != 0) {
                switch (code) {
                    case 1: {
                        i = (i & 0x1F) << 6 | inBuf[inPtr++] & 0x3F;
                        break;
                    }
                    case 2: {
                        i = (i & 0xF) << 12 | (inBuf[inPtr++] & 0x3F) << 6 | inBuf[inPtr++] & 0x3F;
                        break;
                    }
                    case 3: {
                        i = (i & 7) << 18 | (inBuf[inPtr++] & 0x3F) << 12 | (inBuf[inPtr++] & 0x3F) << 6 | inBuf[inPtr++] & 0x3F;
                        outBuf[outPtr++] = (char)(0xD800 | (i -= 65536) >> 10);
                        i = 0xDC00 | i & 0x3FF;
                        break;
                    }
                    default: {
                        this._reportError("Invalid byte 0x%02x in short Unicode text block (offset %d)", i & 0xFF, inPtr);
                    }
                }
                if ((estSlack -= code) <= 0) {
                    outBuf = this._textBuffer.expandCurrentSegment();
                    estSlack = outBuf.length - outPtr - (end - inPtr) - 8;
                }
            }
            outBuf[outPtr++] = (char)i;
        }
        this._textBuffer.setCurrentLength(outPtr);
        return this._textBuffer.contentsAsString();
    }

    private final int _fourBytesToInt(int ptr) throws IOException {
        int i = this._inputBuffer[ptr++];
        i = (i << 7) + this._inputBuffer[ptr++];
        i = (i << 7) + this._inputBuffer[ptr++];
        i = (i << 7) + this._inputBuffer[ptr++];
        return i;
    }

    private final int _decodeVInt() throws IOException {
        byte i;
        int value;
        int ptr = this._inputPtr;
        if ((value = this._inputBuffer[ptr++]) < 0) {
            this._inputPtr = ptr;
            return value & 0x3F;
        }
        if ((i = this._inputBuffer[ptr++]) >= 0) {
            value = (value << 7) + i;
            if ((i = this._inputBuffer[ptr++]) >= 0) {
                value = (value << 7) + i;
                if ((i = this._inputBuffer[ptr++]) >= 0) {
                    value = (value << 7) + i;
                    if ((i = this._inputBuffer[ptr++]) >= 0) {
                        this._reportError("Corrupt input; 32-bit VInt extends beyond 5 data bytes");
                    }
                }
            }
        }
        this._inputPtr = ptr;
        return (value << 6) + (i & 0x3F);
    }

    private final boolean _decode7BitEncoded() throws IOException {
        int bytesToDecode = this._pending32;
        int buffered = this._inputCopyLen;
        int ptr = this._inputPtr;
        int avail = this._inputEnd - ptr;
        if (buffered > 0) {
            if (bytesToDecode < 7) {
                return this._decode7BitEncodedTail(bytesToDecode, buffered);
            }
            int needed = 8 - buffered;
            if (avail < needed) {
                System.arraycopy(this._inputBuffer, ptr, this._inputCopy, buffered, avail);
                this._inputPtr = ptr + avail;
                this._inputCopyLen = buffered + avail;
                this._pending32 = bytesToDecode;
                return false;
            }
            this._inputCopyLen = 0;
            byte[] copy = this._inputCopy;
            System.arraycopy(this._inputBuffer, ptr, copy, buffered, needed);
            int i1 = (copy[0] << 25) + (copy[1] << 18) + (copy[2] << 11) + (copy[3] << 4);
            byte x = copy[4];
            this._byteArrayBuilder.appendFourBytes(i1 += x >> 3);
            i1 = ((x & 7) << 21) + (copy[5] << 14) + (copy[6] << 7) + copy[7];
            this._byteArrayBuilder.appendThreeBytes(i1);
            bytesToDecode -= 7;
            avail = this._inputEnd - (ptr += needed);
        }
        byte[] input = this._inputBuffer;
        while (bytesToDecode > 6) {
            if (avail < 8) {
                if (avail > 0) {
                    System.arraycopy(this._inputBuffer, ptr, this._inputCopy, 0, avail);
                    ptr += avail;
                    this._inputCopyLen = avail;
                }
                this._pending32 = bytesToDecode;
                this._inputPtr = ptr;
                return false;
            }
            int i1 = (input[ptr++] << 25) + (input[ptr++] << 18) + (input[ptr++] << 11) + (input[ptr++] << 4);
            byte x = input[ptr++];
            this._byteArrayBuilder.appendFourBytes(i1 += x >> 3);
            i1 = ((x & 7) << 21) + (input[ptr++] << 14) + (input[ptr++] << 7) + input[ptr++];
            this._byteArrayBuilder.appendThreeBytes(i1);
            bytesToDecode -= 7;
            avail -= 8;
        }
        this._inputPtr = ptr;
        if (bytesToDecode > 0) {
            if (avail == 0) {
                this._pending32 = bytesToDecode;
                this._inputCopyLen = 0;
                return false;
            }
            return this._decode7BitEncodedTail(bytesToDecode, 0);
        }
        return true;
    }

    protected final boolean _decode7BitEncodedTail(int bytesToDecode, int buffered) throws IOException {
        if (bytesToDecode == 0) {
            return true;
        }
        int avail = this._inputEnd - this._inputPtr;
        int needed = bytesToDecode + 1 - buffered;
        if (avail < needed) {
            System.arraycopy(this._inputBuffer, this._inputPtr, this._inputCopy, buffered, avail);
            this._inputPtr += avail;
            this._inputCopyLen = buffered + avail;
            this._pending32 = bytesToDecode;
            return false;
        }
        System.arraycopy(this._inputBuffer, this._inputPtr, this._inputCopy, buffered, needed);
        this._inputPtr += needed;
        int value = this._inputCopy[0];
        for (int i = 1; i < bytesToDecode; ++i) {
            value = (value << 7) + this._inputCopy[i];
            this._byteArrayBuilder.append(value >> 7 - i);
        }
        this._byteArrayBuilder.append((value <<= bytesToDecode) + this._inputCopy[bytesToDecode]);
        this._inputCopyLen = 0;
        return true;
    }
}

