/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.block;

import com.facebook.presto.jdbc.internal.common.array.Arrays;
import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.BlockUtil;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.javax.annotation.Nullable;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.ObjLongConsumer;

public class ByteArrayBlock
implements Block {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ByteArrayBlock.class).instanceSize();
    public static final int SIZE_IN_BYTES_PER_POSITION = 2;
    private final int arrayOffset;
    private final int positionCount;
    @Nullable
    private final boolean[] valueIsNull;
    private final byte[] values;
    private final long retainedSizeInBytes;

    public ByteArrayBlock(int positionCount, Optional<boolean[]> valueIsNull, byte[] values) {
        this(0, positionCount, valueIsNull.orElse(null), values);
    }

    ByteArrayBlock(int arrayOffset, int positionCount, boolean[] valueIsNull, byte[] values) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        this.arrayOffset = arrayOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (values.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("values length is less than positionCount");
        }
        this.values = values;
        if (valueIsNull != null && valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf(valueIsNull) + SizeOf.sizeOf(values);
    }

    @Override
    public long getSizeInBytes() {
        return 2L * (long)this.positionCount;
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        return 2L * (long)length;
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        return OptionalInt.of(2);
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] usedPositions, int usedPositionCount) {
        return 2L * (long)usedPositionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        return this.isNull(position) ? 0L : 1L;
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this.values, SizeOf.sizeOf(this.values));
        if (this.valueIsNull != null) {
            consumer.accept(this.valueIsNull, SizeOf.sizeOf(this.valueIsNull));
        }
        consumer.accept(this, INSTANCE_SIZE);
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public byte getByte(int position) {
        this.checkReadablePosition(position);
        return this.getByteUnchecked(position + this.arrayOffset);
    }

    @Override
    public boolean mayHaveNull() {
        return this.valueIsNull != null;
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.valueIsNull != null && this.isNullUnchecked(position + this.arrayOffset);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        blockBuilder.writeByte(this.values[position + this.arrayOffset]);
        blockBuilder.closeEntry();
    }

    @Override
    public void writePositionTo(int position, SliceOutput output) {
        if (this.isNull(position)) {
            output.writeByte(0);
        } else {
            output.writeByte(1);
            output.writeByte(this.values[position + this.arrayOffset]);
        }
    }

    @Override
    public Block getSingleValueBlock(int position) {
        boolean[] blArray;
        this.checkReadablePosition(position);
        if (this.isNull(position)) {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = true;
        } else {
            blArray = null;
        }
        return new ByteArrayBlock(0, 1, blArray, new byte[]{this.values[position + this.arrayOffset]});
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        boolean[] newValueIsNull = null;
        if (this.valueIsNull != null) {
            newValueIsNull = new boolean[length];
        }
        byte[] newValues = new byte[length];
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            this.checkReadablePosition(position);
            if (this.valueIsNull != null) {
                newValueIsNull[i] = this.valueIsNull[position + this.arrayOffset];
            }
            newValues[i] = this.values[position + this.arrayOffset];
        }
        return new ByteArrayBlock(0, length, newValueIsNull, newValues);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new ByteArrayBlock(positionOffset + this.arrayOffset, length, this.valueIsNull, this.values);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        boolean[] newValueIsNull = this.valueIsNull == null ? null : BlockUtil.compactArray(this.valueIsNull, positionOffset += this.arrayOffset, length);
        byte[] newValues = BlockUtil.compactArray(this.values, positionOffset, length);
        if (newValueIsNull == this.valueIsNull && newValues == this.values) {
            return this;
        }
        return new ByteArrayBlock(0, length, newValueIsNull, newValues);
    }

    @Override
    public String getEncodingName() {
        return "BYTE_ARRAY";
    }

    public String toString() {
        return String.format("ByteArrayBlock(%d){positionCount=%d}", this.hashCode(), this.getPositionCount());
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }

    @Override
    public int getOffsetBase() {
        return this.arrayOffset;
    }

    @Override
    public boolean isNullUnchecked(int internalPosition) {
        assert (this.mayHaveNull()) : "no nulls present";
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.valueIsNull[internalPosition];
    }

    @Override
    public byte getByteUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.values[internalPosition];
    }

    @Override
    public Block appendNull() {
        boolean[] newValueIsNull = BlockUtil.appendNullToIsNullArray(this.valueIsNull, this.arrayOffset, this.positionCount);
        byte[] newValues = Arrays.ensureCapacity(this.values, this.arrayOffset + this.positionCount + 1, Arrays.ExpansionFactor.SMALL, Arrays.ExpansionOption.PRESERVE);
        return new ByteArrayBlock(this.arrayOffset, this.positionCount + 1, newValueIsNull, newValues);
    }

    @Override
    public long toLong(int position) {
        this.checkReadablePosition(position);
        return this.getByteUnchecked(position + this.arrayOffset);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArrayBlock other = (ByteArrayBlock)obj;
        return this.arrayOffset == other.arrayOffset && this.positionCount == other.positionCount && java.util.Arrays.equals(this.valueIsNull, other.valueIsNull) && java.util.Arrays.equals(this.values, other.values) && this.retainedSizeInBytes == other.retainedSizeInBytes;
    }

    public int hashCode() {
        return Objects.hash(this.arrayOffset, this.positionCount, java.util.Arrays.hashCode(this.valueIsNull), java.util.Arrays.hashCode(this.values), this.retainedSizeInBytes);
    }
}

