/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoException;
import com.mongodb.MongoInterruptedException;
import com.mongodb.MongoSecurityException;
import com.mongodb.ServerAddress;
import com.mongodb.ServerApi;
import com.mongodb.SubjectProvider;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.Locks;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.connection.Authenticator;
import com.mongodb.internal.connection.CommandHelper;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.MongoCredentialWithCache;
import com.mongodb.internal.connection.SpeculativeAuthenticator;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;

abstract class SaslAuthenticator
extends Authenticator
implements SpeculativeAuthenticator {
    public static final Logger LOGGER = Loggers.getLogger("authenticator");
    private static final String SUBJECT_PROVIDER_CACHE_KEY = "SUBJECT_PROVIDER";

    SaslAuthenticator(MongoCredentialWithCache credential, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(credential, clusterConnectionMode, serverApi);
    }

    @Override
    public void authenticate(InternalConnection connection2, ConnectionDescription connectionDescription) {
        this.doAsSubject(() -> {
            SaslClient saslClient = this.createSaslClient(connection2.getDescription().getServerAddress());
            this.throwIfSaslClientIsNull(saslClient);
            try {
                BsonDocument responseDocument = this.getNextSaslResponse(saslClient, connection2);
                BsonInt32 conversationId = responseDocument.getInt32("conversationId");
                while (!responseDocument.getBoolean("done").getValue()) {
                    byte[] response = saslClient.evaluateChallenge(responseDocument.getBinary("payload").getData());
                    if (response == null) {
                        throw new MongoSecurityException(this.getMongoCredential(), "SASL protocol error: no client response to challenge for credential " + this.getMongoCredential());
                    }
                    responseDocument = this.sendSaslContinue(conversationId, response, connection2);
                }
                if (!saslClient.isComplete()) {
                    saslClient.evaluateChallenge(responseDocument.getBinary("payload").getData());
                    if (!saslClient.isComplete()) {
                        throw new MongoSecurityException(this.getMongoCredential(), "SASL protocol error: server completed challenges before client completed responses " + this.getMongoCredential());
                    }
                }
            }
            catch (Exception e) {
                throw this.wrapException(e);
            }
            finally {
                this.disposeOfSaslClient(saslClient);
            }
            return null;
        });
    }

    @Override
    void authenticateAsync(InternalConnection connection2, ConnectionDescription connectionDescription, SingleResultCallback<Void> callback) {
        try {
            this.doAsSubject(() -> {
                SaslClient saslClient = this.createSaslClient(connection2.getDescription().getServerAddress());
                this.throwIfSaslClientIsNull(saslClient);
                this.getNextSaslResponseAsync(saslClient, connection2, callback);
                return null;
            });
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    public abstract String getMechanismName();

    protected abstract SaslClient createSaslClient(ServerAddress var1);

    protected void appendSaslStartOptions(BsonDocument saslStartCommand) {
    }

    private void throwIfSaslClientIsNull(@Nullable SaslClient saslClient) {
        if (saslClient == null) {
            throw new MongoSecurityException(this.getMongoCredential(), String.format("This JDK does not support the %s SASL mechanism", this.getMechanismName()));
        }
    }

    private BsonDocument getNextSaslResponse(SaslClient saslClient, InternalConnection connection2) {
        BsonDocument response = this.getSpeculativeAuthenticateResponse();
        if (response != null) {
            return response;
        }
        try {
            byte[] serverResponse = saslClient.hasInitialResponse() ? saslClient.evaluateChallenge(new byte[0]) : null;
            return this.sendSaslStart(serverResponse, connection2);
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
    }

    private void getNextSaslResponseAsync(SaslClient saslClient, InternalConnection connection2, SingleResultCallback<Void> callback) {
        BsonDocument response = this.getSpeculativeAuthenticateResponse();
        SingleResultCallback<Void> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
        try {
            if (response == null) {
                byte[] serverResponse = saslClient.hasInitialResponse() ? saslClient.evaluateChallenge(new byte[0]) : null;
                this.sendSaslStartAsync(serverResponse, connection2, (result, t) -> {
                    if (t != null) {
                        errHandlingCallback.onResult(null, this.wrapException(t));
                        return;
                    }
                    Assertions.assertNotNull(result);
                    if (result.getBoolean("done").getValue()) {
                        this.verifySaslClientComplete(saslClient, (BsonDocument)result, errHandlingCallback);
                    } else {
                        new Continuator(saslClient, (BsonDocument)result, connection2, errHandlingCallback).start();
                    }
                });
            } else if (response.getBoolean("done").getValue()) {
                this.verifySaslClientComplete(saslClient, response, errHandlingCallback);
            } else {
                new Continuator(saslClient, response, connection2, errHandlingCallback).start();
            }
        }
        catch (Exception e) {
            callback.onResult(null, this.wrapException(e));
        }
    }

    private void verifySaslClientComplete(SaslClient saslClient, BsonDocument result, SingleResultCallback<Void> callback) {
        if (saslClient.isComplete()) {
            callback.onResult(null, null);
        } else {
            try {
                saslClient.evaluateChallenge(result.getBinary("payload").getData());
                if (saslClient.isComplete()) {
                    callback.onResult(null, null);
                } else {
                    callback.onResult(null, new MongoSecurityException(this.getMongoCredential(), "SASL protocol error: server completed challenges before client completed responses " + this.getMongoCredential()));
                }
            }
            catch (SaslException e) {
                callback.onResult(null, this.wrapException(e));
            }
        }
    }

    @Nullable
    protected Subject getSubject() {
        Subject subject = this.getMongoCredential().getMechanismProperty("JAVA_SUBJECT", null);
        if (subject != null) {
            return subject;
        }
        try {
            return this.getSubjectProvider().getSubject();
        }
        catch (LoginException e) {
            throw new MongoSecurityException(this.getMongoCredential(), "Failed to login Subject", (Throwable)e);
        }
    }

    @NonNull
    private SubjectProvider getSubjectProvider() {
        return Locks.withInterruptibleLock(this.getMongoCredentialWithCache().getLock(), () -> {
            SubjectProvider subjectProvider = this.getMongoCredentialWithCache().getFromCache(SUBJECT_PROVIDER_CACHE_KEY, SubjectProvider.class);
            if (subjectProvider == null) {
                subjectProvider = this.getMongoCredential().getMechanismProperty("JAVA_SUBJECT_PROVIDER", null);
                if (subjectProvider == null) {
                    subjectProvider = this.getDefaultSubjectProvider();
                }
                this.getMongoCredentialWithCache().putInCache(SUBJECT_PROVIDER_CACHE_KEY, subjectProvider);
            }
            return subjectProvider;
        });
    }

    @NonNull
    protected SubjectProvider getDefaultSubjectProvider() {
        return () -> null;
    }

    private BsonDocument sendSaslStart(@Nullable byte[] outToken, InternalConnection connection2) {
        BsonDocument startDocument = this.createSaslStartCommandDocument(outToken);
        this.appendSaslStartOptions(startDocument);
        return CommandHelper.executeCommand(this.getMongoCredential().getSource(), startDocument, this.getClusterConnectionMode(), this.getServerApi(), connection2);
    }

    private BsonDocument sendSaslContinue(BsonInt32 conversationId, byte[] outToken, InternalConnection connection2) {
        return CommandHelper.executeCommand(this.getMongoCredential().getSource(), this.createSaslContinueDocument(conversationId, outToken), this.getClusterConnectionMode(), this.getServerApi(), connection2);
    }

    private void sendSaslStartAsync(@Nullable byte[] outToken, InternalConnection connection2, SingleResultCallback<BsonDocument> callback) {
        BsonDocument startDocument = this.createSaslStartCommandDocument(outToken);
        this.appendSaslStartOptions(startDocument);
        CommandHelper.executeCommandAsync(this.getMongoCredential().getSource(), startDocument, this.getClusterConnectionMode(), this.getServerApi(), connection2, callback);
    }

    private void sendSaslContinueAsync(BsonInt32 conversationId, byte[] outToken, InternalConnection connection2, SingleResultCallback<BsonDocument> callback) {
        CommandHelper.executeCommandAsync(this.getMongoCredential().getSource(), this.createSaslContinueDocument(conversationId, outToken), this.getClusterConnectionMode(), this.getServerApi(), connection2, callback);
    }

    protected BsonDocument createSaslStartCommandDocument(@Nullable byte[] outToken) {
        return new BsonDocument("saslStart", new BsonInt32(1)).append("mechanism", new BsonString(this.getMechanismName())).append("payload", new BsonBinary(outToken != null ? outToken : new byte[]{}));
    }

    private BsonDocument createSaslContinueDocument(BsonInt32 conversationId, byte[] outToken) {
        return new BsonDocument("saslContinue", new BsonInt32(1)).append("conversationId", conversationId).append("payload", new BsonBinary(outToken));
    }

    private void disposeOfSaslClient(SaslClient saslClient) {
        try {
            saslClient.dispose();
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    protected MongoException wrapException(Throwable t) {
        if (t instanceof MongoInterruptedException) {
            return (MongoInterruptedException)t;
        }
        if (t instanceof MongoSecurityException) {
            return (MongoSecurityException)t;
        }
        return new MongoSecurityException(this.getMongoCredential(), "Exception authenticating " + this.getMongoCredential(), t);
    }

    void doAsSubject(PrivilegedAction<Void> action) {
        Subject subject = this.getSubject();
        if (subject == null) {
            action.run();
        } else {
            Subject.doAs(subject, action);
        }
    }

    private final class Continuator
    implements SingleResultCallback<BsonDocument> {
        private final SaslClient saslClient;
        private final BsonDocument saslStartDocument;
        private final InternalConnection connection;
        private final SingleResultCallback<Void> callback;

        Continuator(SaslClient saslClient, BsonDocument saslStartDocument, InternalConnection connection2, SingleResultCallback<Void> callback) {
            this.saslClient = saslClient;
            this.saslStartDocument = saslStartDocument;
            this.connection = connection2;
            this.callback = callback;
        }

        @Override
        public void onResult(@Nullable BsonDocument result, @Nullable Throwable t) {
            if (t != null) {
                this.callback.onResult(null, SaslAuthenticator.this.wrapException(t));
                SaslAuthenticator.this.disposeOfSaslClient(this.saslClient);
                return;
            }
            Assertions.assertNotNull(result);
            if (result.getBoolean("done").getValue()) {
                SaslAuthenticator.this.verifySaslClientComplete(this.saslClient, result, this.callback);
                SaslAuthenticator.this.disposeOfSaslClient(this.saslClient);
            } else {
                this.continueConversation(result);
            }
        }

        public void start() {
            this.continueConversation(this.saslStartDocument);
        }

        private void continueConversation(BsonDocument result) {
            try {
                SaslAuthenticator.this.doAsSubject(() -> {
                    try {
                        SaslAuthenticator.this.sendSaslContinueAsync(this.saslStartDocument.getInt32("conversationId"), this.saslClient.evaluateChallenge(result.getBinary("payload").getData()), this.connection, this);
                    }
                    catch (SaslException e) {
                        throw SaslAuthenticator.this.wrapException(e);
                    }
                    return null;
                });
            }
            catch (Throwable t) {
                this.callback.onResult(null, t);
                SaslAuthenticator.this.disposeOfSaslClient(this.saslClient);
            }
        }
    }
}

