/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.CursorType;
import com.mongodb.ExplainVerbosity;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.internal.MongoIterableImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.client.model.FindOptions;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.ExplainableReadOperation;
import com.mongodb.internal.operation.SyncOperations;
import com.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class FindIterableImpl<TDocument, TResult>
extends MongoIterableImpl<TResult>
implements FindIterable<TResult> {
    private final SyncOperations<TDocument> operations;
    private final Class<TResult> resultClass;
    private final FindOptions findOptions;
    private final CodecRegistry codecRegistry;
    private Bson filter;

    FindIterableImpl(@Nullable ClientSession clientSession, MongoNamespace namespace, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, OperationExecutor executor, Bson filter) {
        this(clientSession, namespace, documentClass, resultClass, codecRegistry, readPreference, readConcern, executor, filter, true);
    }

    FindIterableImpl(@Nullable ClientSession clientSession, MongoNamespace namespace, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, OperationExecutor executor, Bson filter, boolean retryReads) {
        super(clientSession, executor, readConcern, readPreference, retryReads);
        this.operations = new SyncOperations<TDocument>(namespace, documentClass, readPreference, codecRegistry, retryReads);
        this.resultClass = Assertions.notNull("resultClass", resultClass);
        this.filter = Assertions.notNull("filter", filter);
        this.findOptions = new FindOptions();
        this.codecRegistry = codecRegistry;
    }

    @Override
    public FindIterable<TResult> filter(@Nullable Bson filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public FindIterable<TResult> limit(int limit) {
        this.findOptions.limit(limit);
        return this;
    }

    @Override
    public FindIterable<TResult> skip(int skip) {
        this.findOptions.skip(skip);
        return this;
    }

    @Override
    public FindIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.findOptions.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public FindIterable<TResult> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.findOptions.maxAwaitTime(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public FindIterable<TResult> batchSize(int batchSize) {
        super.batchSize(batchSize);
        this.findOptions.batchSize(batchSize);
        return this;
    }

    @Override
    public FindIterable<TResult> collation(@Nullable Collation collation) {
        this.findOptions.collation(collation);
        return this;
    }

    @Override
    public FindIterable<TResult> projection(@Nullable Bson projection) {
        this.findOptions.projection(projection);
        return this;
    }

    @Override
    public FindIterable<TResult> sort(@Nullable Bson sort2) {
        this.findOptions.sort(sort2);
        return this;
    }

    @Override
    public FindIterable<TResult> noCursorTimeout(boolean noCursorTimeout) {
        this.findOptions.noCursorTimeout(noCursorTimeout);
        return this;
    }

    @Override
    @Deprecated
    public FindIterable<TResult> oplogReplay(boolean oplogReplay) {
        this.findOptions.oplogReplay(oplogReplay);
        return this;
    }

    @Override
    public FindIterable<TResult> partial(boolean partial) {
        this.findOptions.partial(partial);
        return this;
    }

    @Override
    public FindIterable<TResult> cursorType(CursorType cursorType) {
        this.findOptions.cursorType(cursorType);
        return this;
    }

    @Override
    public FindIterable<TResult> comment(@Nullable String comment) {
        this.findOptions.comment(comment);
        return this;
    }

    @Override
    public FindIterable<TResult> comment(@Nullable BsonValue comment) {
        this.findOptions.comment(comment);
        return this;
    }

    @Override
    public FindIterable<TResult> hint(@Nullable Bson hint) {
        this.findOptions.hint(hint);
        return this;
    }

    @Override
    public FindIterable<TResult> hintString(@Nullable String hint) {
        this.findOptions.hintString(hint);
        return this;
    }

    @Override
    public FindIterable<TResult> let(@Nullable Bson variables) {
        this.findOptions.let(variables);
        return this;
    }

    @Override
    public FindIterable<TResult> max(@Nullable Bson max) {
        this.findOptions.max(max);
        return this;
    }

    @Override
    public FindIterable<TResult> min(@Nullable Bson min) {
        this.findOptions.min(min);
        return this;
    }

    @Override
    public FindIterable<TResult> returnKey(boolean returnKey) {
        this.findOptions.returnKey(returnKey);
        return this;
    }

    @Override
    public FindIterable<TResult> showRecordId(boolean showRecordId) {
        this.findOptions.showRecordId(showRecordId);
        return this;
    }

    @Override
    public FindIterable<TResult> allowDiskUse(@Nullable Boolean allowDiskUse) {
        this.findOptions.allowDiskUse(allowDiskUse);
        return this;
    }

    @Override
    @Nullable
    public TResult first() {
        try (BatchCursor<TResult> batchCursor = this.getExecutor().execute(this.operations.findFirst(this.filter, this.resultClass, this.findOptions), this.getReadPreference(), this.getReadConcern(), this.getClientSession());){
            TResult TResult = batchCursor.hasNext() ? (TResult)batchCursor.next().iterator().next() : null;
            return TResult;
        }
    }

    @Override
    public Document explain() {
        return this.executeExplain(Document.class, null);
    }

    @Override
    public Document explain(ExplainVerbosity verbosity) {
        return this.executeExplain(Document.class, Assertions.notNull("verbosity", verbosity));
    }

    @Override
    public <E> E explain(Class<E> explainDocumentClass) {
        return this.executeExplain(explainDocumentClass, null);
    }

    @Override
    public <E> E explain(Class<E> explainResultClass, ExplainVerbosity verbosity) {
        return this.executeExplain(explainResultClass, Assertions.notNull("verbosity", verbosity));
    }

    private <E> E executeExplain(Class<E> explainResultClass, @Nullable ExplainVerbosity verbosity) {
        Assertions.notNull("explainDocumentClass", explainResultClass);
        return this.getExecutor().execute(this.asReadOperation().asExplainableOperation(verbosity, this.codecRegistry.get(explainResultClass)), this.getReadPreference(), this.getReadConcern(), this.getClientSession());
    }

    @Override
    public ExplainableReadOperation<BatchCursor<TResult>> asReadOperation() {
        return this.operations.find(this.filter, this.resultClass, this.findOptions);
    }
}

