/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.jdbc.common;

import com.simba.athena.jdbc.interfaces.IJDBCPreparedStatement;
import com.simba.athena.jdbc.interfaces.IPooledConnection;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class SPreparedStatementHandle
implements PreparedStatement {
    private final IJDBCPreparedStatement m_preparedStatement;
    private final IPooledConnection m_pooledConnection;

    public SPreparedStatementHandle(IPooledConnection iPooledConnection, IJDBCPreparedStatement iJDBCPreparedStatement) {
        if (iPooledConnection == null || iJDBCPreparedStatement == null) {
            throw null;
        }
        this.m_preparedStatement = iJDBCPreparedStatement;
        this.m_pooledConnection = iPooledConnection;
    }

    protected final IJDBCPreparedStatement getPreparedStatement() {
        return this.m_preparedStatement;
    }

    protected final IPooledConnection getPooledConnection() {
        return this.m_pooledConnection;
    }

    protected SQLException handleException(SQLException sQLException) throws SQLException {
        if (this.m_preparedStatement.isClosed()) {
            this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
        }
        return sQLException;
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        try {
            return this.m_preparedStatement.executeQuery(string);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        try {
            return this.m_preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void close() throws SQLException {
        this.m_pooledConnection.onHandleStatementClose(this.m_preparedStatement);
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            return this.m_preparedStatement.getMaxFieldSize();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        try {
            this.m_preparedStatement.setMaxFieldSize(n);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            return this.m_preparedStatement.getMaxRows();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        try {
            this.m_preparedStatement.setMaxRows(n);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        try {
            this.m_preparedStatement.setEscapeProcessing(bl);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            return this.m_preparedStatement.getQueryTimeout();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        try {
            this.m_preparedStatement.setQueryTimeout(n);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            this.m_preparedStatement.cancel();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.m_preparedStatement.getWarnings();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.m_preparedStatement.clearWarnings();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        try {
            this.m_preparedStatement.setCursorName(string);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public boolean execute(String string) throws SQLException {
        try {
            return this.m_preparedStatement.execute(string);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            return this.m_preparedStatement.getResultSet();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            return this.m_preparedStatement.getUpdateCount();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            return this.m_preparedStatement.getMoreResults();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        try {
            this.m_preparedStatement.setFetchDirection(n);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            return this.m_preparedStatement.getFetchDirection();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        try {
            this.m_preparedStatement.setFetchSize(n);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            return this.m_preparedStatement.getFetchSize();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            return this.m_preparedStatement.getResultSetConcurrency();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            return this.m_preparedStatement.getResultSetType();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void addBatch(String string) throws SQLException {
        try {
            this.m_preparedStatement.addBatch(string);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this.m_preparedStatement.clearBatch();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            return this.m_preparedStatement.executeBatch();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return this.m_preparedStatement.getConnection();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        try {
            return this.m_preparedStatement.getMoreResults(n);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            return this.m_preparedStatement.getGeneratedKeys();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        try {
            return this.m_preparedStatement.executeUpdate(string, n);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            return this.m_preparedStatement.executeUpdate(string, nArray);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            return this.m_preparedStatement.executeUpdate(string, stringArray);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        try {
            return this.m_preparedStatement.execute(string, n);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        try {
            return this.m_preparedStatement.execute(string, nArray);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            return this.m_preparedStatement.execute(string, stringArray);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this.m_preparedStatement.getResultSetHoldability();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this.m_preparedStatement.isClosed();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        try {
            this.m_preparedStatement.setPoolable(bl);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        try {
            return this.m_preparedStatement.isPoolable();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return this.m_preparedStatement.unwrap(clazz);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        try {
            return this.m_preparedStatement.isWrapperFor(clazz);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        try {
            return this.m_preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            return this.m_preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        try {
            this.m_preparedStatement.setNull(n, n2);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        try {
            this.m_preparedStatement.setBoolean(n, bl);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        try {
            this.m_preparedStatement.setByte(n, by);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        try {
            this.m_preparedStatement.setShort(n, s);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        try {
            this.m_preparedStatement.setInt(n, n2);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        try {
            this.m_preparedStatement.setLong(n, l);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        try {
            this.m_preparedStatement.setFloat(n, f);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        try {
            this.m_preparedStatement.setDouble(n, d);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            this.m_preparedStatement.setBigDecimal(n, bigDecimal);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        try {
            this.m_preparedStatement.setString(n, string);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        try {
            this.m_preparedStatement.setBytes(n, byArray);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        try {
            this.m_preparedStatement.setDate(n, date);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        try {
            this.m_preparedStatement.setTime(n, time);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            this.m_preparedStatement.setTimestamp(n, timestamp);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.m_preparedStatement.setAsciiStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.m_preparedStatement.setUnicodeStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.m_preparedStatement.setBinaryStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        try {
            this.m_preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        try {
            this.m_preparedStatement.setObject(n, object, n2);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        try {
            this.m_preparedStatement.setObject(n, object);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public boolean execute() throws SQLException {
        try {
            return this.m_preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void addBatch() throws SQLException {
        try {
            this.m_preparedStatement.addBatch();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            this.m_preparedStatement.setCharacterStream(n, reader, n2);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        try {
            this.m_preparedStatement.setRef(n, ref);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        try {
            this.m_preparedStatement.setBlob(n, blob);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        try {
            this.m_preparedStatement.setClob(n, clob);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        try {
            this.m_preparedStatement.setArray(n, array);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this.m_preparedStatement.getMetaData();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        try {
            this.m_preparedStatement.setDate(n, date, calendar);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        try {
            this.m_preparedStatement.setTime(n, time, calendar);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        try {
            this.m_preparedStatement.setTimestamp(n, timestamp, calendar);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        try {
            this.m_preparedStatement.setNull(n, n2, string);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        try {
            this.m_preparedStatement.setURL(n, uRL);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            return this.m_preparedStatement.getParameterMetaData();
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        try {
            this.m_preparedStatement.setRowId(n, rowId);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        try {
            this.m_preparedStatement.setNString(n, string);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        try {
            this.m_preparedStatement.setNCharacterStream(n, reader, l);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        try {
            this.m_preparedStatement.setNClob(n, nClob);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        try {
            this.m_preparedStatement.setClob(n, reader, l);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        try {
            this.m_preparedStatement.setBlob(n, inputStream, l);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        try {
            this.m_preparedStatement.setNClob(n, reader, l);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        try {
            this.m_preparedStatement.setSQLXML(n, sQLXML);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        try {
            this.m_preparedStatement.setObject(n, object, n2, n3);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        try {
            this.m_preparedStatement.setAsciiStream(n, inputStream, l);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        try {
            this.m_preparedStatement.setBinaryStream(n, inputStream, l);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        try {
            this.m_preparedStatement.setCharacterStream(n, reader, l);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        try {
            this.m_preparedStatement.setAsciiStream(n, inputStream);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        try {
            this.m_preparedStatement.setBinaryStream(n, inputStream);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        try {
            this.m_preparedStatement.setCharacterStream(n, reader);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        try {
            this.m_preparedStatement.setNCharacterStream(n, reader);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        try {
            this.m_preparedStatement.setClob(n, reader);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        try {
            this.m_preparedStatement.setBlob(n, inputStream);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        try {
            this.m_preparedStatement.setNClob(n, reader);
        }
        catch (SQLException sQLException) {
            throw this.handleException(sQLException);
        }
    }
}

