/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.jdbc.common;

import com.simba.athena.dsi.dataengine.utilities.ParameterMetadata;
import com.simba.athena.dsi.dataengine.utilities.TypeMetadata;
import com.simba.athena.dsi.dataengine.utilities.TypeUtilities;
import com.simba.athena.exceptions.ExceptionConverter;
import com.simba.athena.exceptions.JDBCMessageKey;
import com.simba.athena.jdbc.common.utilities.WrapperUtilities;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.IWarningListener;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ExceptionType;
import com.simba.athena.utilities.TypeNames;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

public class SParameterMetaData
implements ParameterMetaData {
    private ArrayList<ParameterMetadata> m_parameterMetadata = new ArrayList();
    private boolean m_isOpen = false;
    private ILogger m_logger = null;
    private IWarningListener m_warningListener = null;

    public SParameterMetaData(ArrayList<ParameterMetadata> arrayList, ILogger iLogger, IWarningListener iWarningListener) {
        this.m_logger = iLogger;
        LogUtilities.logFunctionEntrance(this.m_logger, arrayList, iLogger);
        this.m_warningListener = iWarningListener;
        this.m_isOpen = true;
        this.m_parameterMetadata = arrayList;
    }

    @Override
    public String getParameterClassName(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            int n2 = this.getParameterType(n);
            return TypeNames.getTypeClassName(n2);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getParameterCount() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_parameterMetadata.size();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getParameterMode(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            switch (this.getParameterMetadata(n).getParameterType()) {
                case INPUT: {
                    return 1;
                }
                case OUTPUT: {
                    return 4;
                }
                case INPUT_OUTPUT: {
                    return 2;
                }
            }
            return 0;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getParameterType(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            TypeMetadata typeMetadata = this.getTypeMetadata(n);
            return typeMetadata.getType();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getParameterTypeName(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            TypeMetadata typeMetadata = this.getTypeMetadata(n);
            return typeMetadata.getTypeName();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            ParameterMetadata parameterMetadata = this.getParameterMetadata(n);
            TypeMetadata typeMetadata = parameterMetadata.getTypeMetadata();
            short s = typeMetadata.getType();
            if (typeMetadata.isCharacterOrBinaryType()) {
                long l = parameterMetadata.getColumnLength();
                return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
            }
            if (91 == s || 92 == s || 93 == s) {
                return (int)TypeUtilities.getDisplaySize(typeMetadata, 0L);
            }
            if (typeMetadata.isIntervalType()) {
                return typeMetadata.getIntervalPrecision();
            }
            return typeMetadata.getPrecision();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getScale(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            TypeMetadata typeMetadata = this.getTypeMetadata(n);
            return typeMetadata.getScale();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int isNullable(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            ParameterMetadata parameterMetadata = this.getParameterMetadata(n);
            switch (parameterMetadata.getNullable()) {
                case NO_NULLS: {
                    return 0;
                }
                case NULLABLE: {
                    return 1;
                }
            }
            return 2;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            TypeMetadata typeMetadata = this.getTypeMetadata(n);
            return typeMetadata.isSigned();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return WrapperUtilities.isWrapperFor(clazz, this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return WrapperUtilities.unwrap(clazz, this);
    }

    protected synchronized void close() {
        this.m_isOpen = false;
    }

    private synchronized void checkIfOpen() throws SQLException {
        if (!this.m_isOpen) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARAMMETA_CLOSED, this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    private ParameterMetadata getParameterMetadata(int n) throws SQLException {
        if (!this.isValidIndex(n)) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_INDEX, this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(n));
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        return this.m_parameterMetadata.get(n - 1);
    }

    private TypeMetadata getTypeMetadata(int n) throws SQLException {
        ParameterMetadata parameterMetadata = this.getParameterMetadata(n);
        return parameterMetadata.getTypeMetadata();
    }

    private boolean isValidIndex(int n) {
        return 0 < n && this.m_parameterMetadata.size() >= n;
    }
}

