/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.iamsupport.plugin;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.util.IOUtils;
import com.simba.athena.amazonaws.util.StringUtils;
import com.simba.athena.iamsupport.model.CredentialsHolder;
import com.simba.athena.iamsupport.plugin.SamlCredentialsProvider;
import com.simba.athena.iamsupport.plugin.utils.LogUtils;
import com.simba.athena.support.LogUtilities;
import java.io.IOException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class PingCredentialsProvider
extends SamlCredentialsProvider {
    private static final Pattern SAML_PATTERN = Pattern.compile("SAMLResponse\\W+value=\"([^\"]+)\"");
    private static final String KEY_PARTNER_SPID = "partner_spid";
    protected String m_partnerSpId;

    @Override
    public void addParameter(String string, String string2) {
        super.addParameter(string, string2);
        if (KEY_PARTNER_SPID.equalsIgnoreCase(string)) {
            this.m_partnerSpId = string2;
        }
    }

    @Override
    protected String getSamlAssertion() throws IOException {
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        this.checkRequiredParameters();
        this.m_partnerSpId = StringUtils.isNullOrEmpty(this.m_partnerSpId) ? "urn%3Aamazon%3Awebservices" : URLEncoder.encode(this.m_partnerSpId, "UTF-8");
        String string = "https://" + this.m_idpHost + ':' + this.m_idpPort + "/idp/startSSO.ping?PartnerSpId=" + this.m_partnerSpId;
        this.validateURL(string);
        CloseableHttpClient closeableHttpClient = null;
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>(5);
        try {
            Object object;
            Object object2;
            CloseableHttpResponse closeableHttpResponse;
            Object object4;
            Object object5;
            closeableHttpClient = this.getHttpClient();
            HttpGet httpGet = new HttpGet(string);
            if (null != this.m_proxyHost && !this.m_proxyHost.isEmpty() && this.m_useProxyForIdpAuth.booleanValue()) {
                if (this.m_proxyUid != null && !this.m_proxyUid.isEmpty() && this.m_proxyPwd != null && !this.m_proxyPwd.isEmpty()) {
                    object5 = new BasicCredentialsProvider();
                    object5.setCredentials(new AuthScope(this.m_proxyHost, this.m_proxyPort), new UsernamePasswordCredentials(this.m_proxyUid, this.m_proxyPwd));
                    closeableHttpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)object5).setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE).build();
                }
                object5 = new HttpHost(this.m_proxyHost, this.m_proxyPort);
                object4 = RequestConfig.custom().setProxy((HttpHost)object5).build();
                httpGet.setConfig((RequestConfig)object4);
            }
            if ((closeableHttpResponse = closeableHttpClient.execute(httpGet)).getStatusLine().getStatusCode() != 200) {
                throw new IOException("Failed send request: " + closeableHttpResponse.getStatusLine().getReasonPhrase());
            }
            object5 = closeableHttpResponse.getEntity();
            object4 = EntityUtils.toString((HttpEntity)object5);
            for (String object32 : this.getInputTagsfromHTML((String)object4)) {
                object2 = this.getValueByKey(object32, "name");
                object = this.getValueByKey(object32, "value");
                if (((String)object2).contains("user") || ((String)object2).contains("email")) {
                    arrayList.add(new BasicNameValuePair((String)object2, this.m_userName));
                    continue;
                }
                if (((String)object2).contains("pass")) {
                    arrayList.add(new BasicNameValuePair((String)object2, this.m_password));
                    continue;
                }
                if (StringUtils.isNullOrEmpty((String)object2)) continue;
                arrayList.add(new BasicNameValuePair((String)object2, (String)object));
            }
            String string2 = this.getFormAction((String)object4);
            if (!StringUtils.isNullOrEmpty(string2) && string2.startsWith("/")) {
                string = "https://" + this.m_idpHost + ':' + this.m_idpPort + (String)string2;
            }
            this.validateURL(string);
            HttpPost httpPost = new HttpPost(string);
            httpPost.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)arrayList));
            if (null != this.m_proxyHost && !this.m_proxyHost.isEmpty() && this.m_useProxyForIdpAuth.booleanValue()) {
                if (this.m_proxyUid != null && !this.m_proxyUid.isEmpty() && this.m_proxyPwd != null && !this.m_proxyPwd.isEmpty()) {
                    object2 = new BasicCredentialsProvider();
                    object2.setCredentials(new AuthScope(this.m_proxyHost, this.m_proxyPort), new UsernamePasswordCredentials(this.m_proxyUid, this.m_proxyPwd));
                    closeableHttpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)object2).setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE).build();
                }
                object2 = new HttpHost(this.m_proxyHost, this.m_proxyPort);
                object = RequestConfig.custom().setProxy((HttpHost)object2).build();
                httpPost.setConfig((RequestConfig)object);
            }
            if ((closeableHttpResponse = closeableHttpClient.execute(httpPost)).getStatusLine().getStatusCode() != 200) {
                throw new IOException("Failed send request: " + closeableHttpResponse.getStatusLine().getReasonPhrase());
            }
            object2 = EntityUtils.toString(closeableHttpResponse.getEntity());
            object = SAML_PATTERN.matcher((CharSequence)object2);
            if (!((Matcher)object).find()) {
                throw new IOException("Failed to retrieve SAMLAssertion.");
            }
            LogUtilities.logDebug("Exiting", LogUtils.getLogger());
            String string3 = ((Matcher)object).group(1);
            return string3;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SdkClientException("Failed create SSLContext.", generalSecurityException);
        }
        finally {
            IOUtils.closeQuietly(closeableHttpClient, null);
        }
    }

    @Override
    protected CredentialsHolder performPostSAMLAction(String string, String string2, CredentialsHolder credentialsHolder) throws SdkClientException {
        LogUtilities.logDebug(String.format("Entered with parameter value {%s}", string), LogUtils.getLogger());
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        return null;
    }
}

