/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.dsi.core.utilities.impl.future;

import com.simba.athena.dsi.core.utilities.impl.future.ConvertingJDBCDataSink;
import com.simba.athena.dsi.exceptions.ConversionFailed;
import com.simba.athena.dsi.exceptions.IncorrectTypeException;
import com.simba.athena.support.IWarningListener;
import com.simba.athena.support.exceptions.ErrorException;
import java.sql.SQLException;
import java.util.UUID;

public abstract class GuidJDBCDataSink
extends ConvertingJDBCDataSink {
    public GuidJDBCDataSink(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    protected abstract void doSet(UUID var1) throws ErrorException;

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException {
        if (object != null && !(object instanceof UUID)) {
            throw new IncorrectTypeException();
        }
        this.doSet((UUID)object);
    }

    @Override
    public void setNull(int n) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        switch (n) {
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 0: 
            case 1: 
            case 12: 
            case 2000: {
                this.doSet(null);
                break;
            }
            default: {
                throw new IncorrectTypeException();
            }
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            try {
                this.doSet(UUID.fromString(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ConversionFailed(illegalArgumentException);
            }
        }
    }
}

