/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.dsi.core.utilities.impl.future;

import com.simba.athena.dsi.core.utilities.impl.future.NumericJDBCDataSource;
import com.simba.athena.dsi.exceptions.ConversionFailed;
import com.simba.athena.dsi.exceptions.IncorrectTypeException;
import com.simba.athena.support.IWarningListener;
import com.simba.athena.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class BitBooleanJDBCDataSource
extends NumericJDBCDataSource {
    public BitBooleanJDBCDataSource(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    @Override
    public abstract Boolean get() throws ErrorException;

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        Boolean bl = this.get();
        if (bl == null) {
            return null;
        }
        return bl != false ? "1" : "0";
    }

    @Override
    public boolean getBoolean() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        Boolean bl = this.get();
        if (bl == null) {
            return false;
        }
        return bl;
    }

    @Override
    public byte getByte() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        Boolean bl = this.get();
        if (bl == null) {
            return 0;
        }
        if (bl.booleanValue()) {
            return 1;
        }
        return 0;
    }

    @Override
    public short getShort() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return this.getByte();
    }

    @Override
    public int getInt() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return this.getByte();
    }

    @Override
    public long getLong() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return this.getByte();
    }

    @Override
    public float getFloat() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return this.getByte();
    }

    @Override
    public double getDouble() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return this.getByte();
    }

    @Override
    public BigDecimal getBigDecimal() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        Boolean bl = this.get();
        if (bl == null) {
            return null;
        }
        if (bl.booleanValue()) {
            return BigDecimal.ONE;
        }
        return BigDecimal.ZERO;
    }
}

