/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.utilities;

import com.simba.athena.athena.core.AJDriver;
import com.simba.athena.athena.core.AJSettings;
import com.simba.athena.athena.exceptions.AJMessageKey;
import com.simba.athena.support.Pair;
import com.simba.athena.support.exceptions.ErrorException;

public class AJTypeUtilities {
    public static String canonicalizeTypeName(String string) {
        if (null == string) {
            return "";
        }
        int n = string.indexOf(60);
        if (-1 == n && -1 == (n = string.indexOf(40))) {
            n = string.length();
        }
        return string.substring(0, n);
    }

    public static Pair<Integer, Integer> extractDecimalPrecisionAndScale(String string) throws ErrorException {
        int n;
        int n2;
        Pair<Integer, Integer> pair = new Pair<Integer, Integer>(38, 0);
        String string2 = AJTypeUtilities.canonicalizeTypeName(string);
        if ((string2.equalsIgnoreCase("decimal") || string2.equalsIgnoreCase(SQLTypeNames.SQL_DECIMAL.name())) && -1 != (n2 = string.indexOf(40)) && -1 != (n = string.indexOf(44))) {
            try {
                pair.setKey(Integer.parseInt(string.substring(n2 + 1, n).trim()));
            }
            catch (NumberFormatException numberFormatException) {
                throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.GENERAL_ERROR, (Throwable)numberFormatException);
            }
            n2 = n;
            n = string.indexOf(41);
            if (-1 != n) {
                try {
                    pair.setValue(Integer.parseInt(string.substring(n2 + 1, n).trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.GENERAL_ERROR, (Throwable)numberFormatException);
                }
            }
        }
        return pair;
    }

    public static int extractCharacterTypeColMaxLen(String string) throws ErrorException {
        int n = -1;
        String string2 = AJTypeUtilities.canonicalizeTypeName(string);
        if (AJTypeUtilities.isCharacterType(string2)) {
            int n2;
            n = AJTypeUtilities.getDefaultCharacterLength(string2);
            int n3 = string.indexOf(40);
            if (-1 != n3 && -1 != (n2 = string.indexOf(41))) {
                try {
                    n = Integer.parseInt(string.substring(n3 + 1, n2).trim());
                }
                catch (NumberFormatException numberFormatException) {
                    throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.GENERAL_ERROR, (Throwable)numberFormatException);
                }
            }
        }
        return n;
    }

    public static int getDefaultCharacterLength(String string) {
        int n = 65535;
        if (string.equalsIgnoreCase("char") || string.equalsIgnoreCase(SQLTypeNames.SQL_CHAR.name())) {
            n = 1;
        }
        return n;
    }

    public static boolean isCharacterType(String string) {
        return string.equalsIgnoreCase("char") || string.equalsIgnoreCase("varchar") || string.equalsIgnoreCase(SQLTypeNames.SQL_CHAR.name()) || string.equalsIgnoreCase(SQLTypeNames.SQL_VARCHAR.name());
    }

    public static boolean isComplexType(String string) {
        return string.equalsIgnoreCase("array") || string.equalsIgnoreCase("map") || string.equalsIgnoreCase("struct");
    }

    public static int mapAthenaTypeNameToSqlType(String string, AJSettings aJSettings) {
        String string2 = AJTypeUtilities.canonicalizeTypeName(string);
        if (string2.equalsIgnoreCase("boolean")) {
            return 16;
        }
        if (string2.equalsIgnoreCase("tinyint")) {
            return -6;
        }
        if (string2.equalsIgnoreCase("smallint")) {
            return 5;
        }
        if (string2.equalsIgnoreCase("int") || string2.equalsIgnoreCase("integer")) {
            return 4;
        }
        if (string2.equalsIgnoreCase("bigint")) {
            return -5;
        }
        if (string2.equalsIgnoreCase("real") || string2.equalsIgnoreCase("float")) {
            return 7;
        }
        if (string2.equalsIgnoreCase("double")) {
            return 8;
        }
        if (string2.equalsIgnoreCase("decimal")) {
            return 3;
        }
        if (string2.equalsIgnoreCase("date")) {
            return 91;
        }
        if (string2.equalsIgnoreCase("timestamp")) {
            return 93;
        }
        if (string2.equalsIgnoreCase("binary") || string2.equalsIgnoreCase("varbinary")) {
            return -3;
        }
        if (string2.equalsIgnoreCase("char")) {
            return 1;
        }
        if (string2.equalsIgnoreCase("varchar") || string2.equalsIgnoreCase("string") || string2.equalsIgnoreCase("map") || string2.equalsIgnoreCase("struct") || !aJSettings.m_useArraySupport && string2.equalsIgnoreCase("array")) {
            return 12;
        }
        if (aJSettings.m_useArraySupport && string2.equalsIgnoreCase("array")) {
            return 2003;
        }
        return 12;
    }

    public static String mapSQLTypeNameToAthenaTypeName(String string) throws ErrorException {
        String string2 = AJTypeUtilities.canonicalizeTypeName(string);
        if (string2.equalsIgnoreCase(SQLTypeNames.SQL_BIT.name()) || string2.equalsIgnoreCase(SQLTypeNames.BIT.name()) || string2.equalsIgnoreCase(SQLTypeNames.SQL_BOOLEAN.name()) || string2.equalsIgnoreCase(SQLTypeNames.BOOLEAN.name())) {
            return "boolean";
        }
        if (string2.equalsIgnoreCase(SQLTypeNames.SQL_TINYINT.name()) || string2.equalsIgnoreCase(SQLTypeNames.TINYINT.name())) {
            return "tinyint";
        }
        if (string2.equalsIgnoreCase(SQLTypeNames.SQL_SMALLINT.name()) || string2.equalsIgnoreCase(SQLTypeNames.SMALLINT.name())) {
            return "smallint";
        }
        if (string2.equalsIgnoreCase(SQLTypeNames.SQL_INTEGER.name()) || string2.equalsIgnoreCase(SQLTypeNames.INTEGER.name())) {
            return "integer";
        }
        if (string2.equalsIgnoreCase(SQLTypeNames.SQL_BIGINT.name()) || string2.equalsIgnoreCase(SQLTypeNames.BIGINT.name())) {
            return "bigint";
        }
        if (string2.equalsIgnoreCase(SQLTypeNames.SQL_REAL.name()) || string2.equalsIgnoreCase(SQLTypeNames.REAL.name())) {
            return "real";
        }
        if (string2.equalsIgnoreCase(SQLTypeNames.SQL_FLOAT.name()) || string2.equalsIgnoreCase(SQLTypeNames.FLOAT.name())) {
            return "float";
        }
        if (string2.equalsIgnoreCase(SQLTypeNames.SQL_DOUBLE.name()) || string2.equalsIgnoreCase(SQLTypeNames.DOUBLE.name())) {
            return "double";
        }
        if (string2.equalsIgnoreCase(SQLTypeNames.SQL_DECIMAL.name()) || string2.equalsIgnoreCase(SQLTypeNames.DECIMAL.name())) {
            return "decimal";
        }
        if (string2.equalsIgnoreCase(SQLTypeNames.SQL_DATE.name()) || string2.equalsIgnoreCase(SQLTypeNames.DATE.name())) {
            return "date";
        }
        if (string2.equalsIgnoreCase(SQLTypeNames.SQL_TIMESTAMP.name()) || string2.equalsIgnoreCase(SQLTypeNames.TIMESTAMP.name())) {
            return "timestamp";
        }
        if (string2.equalsIgnoreCase(SQLTypeNames.SQL_VARBINARY.name()) || string2.equalsIgnoreCase(SQLTypeNames.VARBINARY.name())) {
            return "varbinary";
        }
        if (string2.equalsIgnoreCase(SQLTypeNames.SQL_CHAR.name()) || string2.equalsIgnoreCase(SQLTypeNames.CHAR.name())) {
            return "char";
        }
        if (string2.equalsIgnoreCase(SQLTypeNames.SQL_VARCHAR.name()) || string2.equalsIgnoreCase(SQLTypeNames.VARCHAR.name())) {
            return "varchar";
        }
        throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.UNSUPPORTED_SQL_TYPE.name(), string2);
    }

    public static String rectifyTypeName(String string) {
        if (string.equalsIgnoreCase("int")) {
            return "integer";
        }
        if (string.equalsIgnoreCase("binary")) {
            return "varbinary";
        }
        if (string.equalsIgnoreCase("row")) {
            return "struct";
        }
        return string;
    }

    public static String rectifyTypeName(String string, int n) {
        if (string.equalsIgnoreCase("varchar") && 65535 < n) {
            return "string";
        }
        return string;
    }

    public static enum SQLTypeNames {
        SQL_BIGINT,
        SQL_BINARY,
        SQL_BIT,
        SQL_BLOB,
        SQL_BOOLEAN,
        SQL_CHAR,
        SQL_CLOB,
        SQL_DATE,
        SQL_DECIMAL,
        SQL_DATALINK,
        SQL_DOUBLE,
        SQL_FLOAT,
        SQL_INTEGER,
        SQL_LONGVARBINARY,
        SQL_LONGNVARCHAR,
        SQL_LONGVARCHAR,
        SQL_NCHAR,
        SQL_NCLOB,
        SQL_NUMERIC,
        SQL_NVARCHAR,
        SQL_REAL,
        SQL_ROWID,
        SQL_SQLXML,
        SQL_SMALLINT,
        SQL_TIME,
        SQL_TIMESTAMP,
        SQL_TINYINT,
        SQL_VARBINARY,
        SQL_VARCHAR,
        BIGINT,
        BINARY,
        BIT,
        BLOB,
        BOOLEAN,
        CHAR,
        CLOB,
        DATE,
        DECIMAL,
        DATALINK,
        DOUBLE,
        FLOAT,
        INTEGER,
        LONGVARBINARY,
        LONGNVARCHAR,
        LONGVARCHAR,
        NCHAR,
        NCLOB,
        NUMERIC,
        NVARCHAR,
        REAL,
        ROWID,
        SQLXML,
        SMALLINT,
        TIME,
        TIMESTAMP,
        TINYINT,
        VARBINARY,
        VARCHAR;

    }
}

