/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.utilities;

import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogUtilities;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="AJAWSLogAppeneder", category="Core", elementType="appender", printObject=true)
public class AJAWSLogAppender
extends AbstractAppender {
    private static ILogger m_logger;
    private SimpleDateFormat m_dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    protected AJAWSLogAppender(String string, Filter filter) {
        super(string, filter, null, false, null);
    }

    @PluginFactory
    public static AJAWSLogAppender createAppender(@PluginAttribute(value="name") String string, @PluginElement(value="Filter") Filter filter, ILogger iLogger) {
        m_logger = iLogger;
        if (string == null) {
            LOGGER.error("There is no name provided for AJAWSLog4jAppeneder");
            return null;
        }
        return new AJAWSLogAppender(string, filter);
    }

    @Override
    public void append(LogEvent logEvent) {
        if (null != logEvent) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Timestamp: " + this.m_dateFormatter.format(new Date(logEvent.getTimeMillis())));
            stringBuilder.append(" Log Level: " + logEvent.getLevel());
            stringBuilder.append(" Thread: " + logEvent.getThreadName());
            stringBuilder.append(" Event Message: " + logEvent.getMessage().getFormattedMessage());
            if (null != logEvent.getThrown()) {
                stringBuilder.append(" Throwable:" + logEvent.getThrown());
            }
            if (Level.ALL.equals(logEvent.getLevel()) || Level.TRACE.equals(logEvent.getLevel())) {
                LogUtilities.logTrace(stringBuilder.toString(), m_logger);
            } else if (Level.DEBUG.equals(logEvent.getLevel())) {
                LogUtilities.logDebug(stringBuilder.toString(), m_logger);
            } else if (Level.INFO.equals(logEvent.getLevel())) {
                LogUtilities.logInfo(stringBuilder.toString(), m_logger);
            } else if (Level.WARN.equals(logEvent.getLevel())) {
                LogUtilities.logWarning(stringBuilder.toString(), m_logger);
            } else if (Level.ERROR.equals(logEvent.getLevel())) {
                LogUtilities.logTrace(stringBuilder.toString(), m_logger);
            } else if (Level.FATAL.equals(logEvent.getLevel())) {
                LogUtilities.logFatal(stringBuilder.toString(), m_logger);
            }
        }
    }
}

