/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.dataengine;

import com.simba.athena.amazonaws.services.athena.model.ResultSetMetadata;
import com.simba.athena.amazonaws.services.athena.model.Row;
import com.simba.athena.athena.api.AJExecutionContext;
import com.simba.athena.athena.core.AJConnection;
import com.simba.athena.athena.core.AJDriver;
import com.simba.athena.athena.core.AJSettings;
import com.simba.athena.athena.dataengine.AJBaseResultSet;
import com.simba.athena.athena.dataengine.AJStatementType;
import com.simba.athena.athena.exceptions.AJMessageKey;
import com.simba.athena.athena.model.AJStreamProducer;
import com.simba.athena.athena.model.AJStreamRowBuffer;
import com.simba.athena.dsi.exceptions.OperationCanceledException;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.IWarningListener;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;

public class AJStreamResultSet
extends AJBaseResultSet {
    private final ArrayBlockingQueue<AJStreamRowBuffer> m_queue;
    private final ExecutorService m_executor;
    private final AJStreamProducer m_producer;
    private boolean m_isAllResultSetRowsConsumed;

    public AJStreamResultSet(ILogger iLogger, IWarningListener iWarningListener, AJConnection aJConnection, AJSettings aJSettings, AJExecutionContext aJExecutionContext, AJStatementType aJStatementType) throws ErrorException {
        int n = aJSettings.m_rowsToFetchPerBlock * 2;
        if (n > Integer.MAX_VALUE) {
            n = Integer.MAX_VALUE;
            LogUtilities.logDebug("RowsToFetchPerBlock*2 Exceeds queue size limit, capping to max integer value.", iLogger);
        }
        LogUtilities.logFunctionEntrance(iLogger, n);
        this.m_logger = iLogger;
        this.m_warningListener = iWarningListener;
        this.m_connection = aJConnection;
        this.m_client = this.m_connection.getClient();
        this.m_settings = aJSettings;
        this.m_isAllResultSetRowsConsumed = false;
        this.m_execContext = aJExecutionContext;
        this.m_executor = this.m_connection.getThreadPool();
        this.m_queue = new ArrayBlockingQueue(n);
        this.m_producer = new AJStreamProducer(this.m_logger, this.m_client, this.m_queue, this.m_execContext, aJStatementType, this.m_settings.m_maxStreamErrorRetry);
        this.m_executor.submit(this.m_producer);
        ResultSetMetadata resultSetMetadata = null;
        try {
            resultSetMetadata = this.dequeue().getResultSetMetadata();
        }
        catch (Exception exception) {
            this.shutdownServices();
            if (((ErrorException)exception).getMessageParams()[0].contains("Permission denied: connect")) {
                throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.NETWORK_CONNECTION_ERROR.name(), ((ErrorException)exception).getMessageParams());
            }
            throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.GENERAL_ERROR_WITH_STREAM_DETAIL.name(), ((ErrorException)exception).getMessageParams());
        }
        if (null != resultSetMetadata) {
            this.initializeColumns(resultSetMetadata.getColumnInfo());
        } else {
            this.shutdownServices();
            this.throwExceptionWithExecutionId(AJMessageKey.GENERAL_ERROR_WITH_STREAM_DETAIL.name() + "No result set metadata available");
        }
        if (AJStatementType.SELECT_OR_VALUES_STATEMENT == aJStatementType || AJStatementType.EXECUTE_STATEMENT == aJStatementType && this.m_client.isExecuteSelectStatement(aJExecutionContext.getQuery(), aJStatementType)) {
            this.dequeue();
        }
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.shutdownServices();
    }

    @Override
    protected void checkCancelFlag() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.m_client.checkCancelFlag(this.m_execContext);
        }
        catch (OperationCanceledException operationCanceledException) {
            this.shutdownServices();
            throw operationCanceledException;
        }
    }

    @Override
    protected void doCloseCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.shutdownServices();
    }

    @Override
    protected boolean doMoveToNextRow() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.m_isAllResultSetRowsConsumed) {
            AJStreamRowBuffer aJStreamRowBuffer = this.dequeue();
            Row row = null;
            try {
                row = aJStreamRowBuffer.getResultRow();
            }
            catch (Exception exception) {
                this.shutdownServices();
                throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.GENERAL_ERROR_WITH_DETAIL.name(), new String[]{"Exception during fetch: " + ((ErrorException)exception).getMessageParams()});
            }
            if (null == aJStreamRowBuffer || null == row) {
                this.m_isAllResultSetRowsConsumed = true;
                return false;
            }
            this.m_currentRow = row;
            this.parseCurrentRow();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return true;
    }

    private AJStreamRowBuffer dequeue() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.checkCancelFlag();
            this.m_producer.checkException();
            AJStreamRowBuffer aJStreamRowBuffer = this.m_queue.take();
            this.m_producer.checkException();
            this.checkCancelFlag();
            return aJStreamRowBuffer;
        }
        catch (InterruptedException interruptedException) {
            this.shutdownServices();
            this.throwExceptionWithExecutionId(AJMessageKey.GENERAL_ERROR.name());
            return null;
        }
    }

    private void performDrain() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_queue.clear();
    }

    private void shutdownServices() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_producer.shutdown();
        this.performDrain();
    }

    private void throwExceptionWithExecutionId(String string) throws ErrorException {
        throw AJDriver.s_AJMessages.createGeneralException(string, null == this.m_execContext || null == this.m_execContext.m_queryExecId || this.m_execContext.m_queryExecId.isEmpty() ? " [Execution ID not available]" : " [Execution ID: " + this.m_execContext.m_queryExecId + "]");
    }
}

