/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.lakeformation.model.transform;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.MarshallLocation;
import com.simba.athena.amazonaws.protocol.MarshallingInfo;
import com.simba.athena.amazonaws.protocol.MarshallingType;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.services.lakeformation.model.ResourceInfo;
import java.util.Date;

@SdkInternalApi
public class ResourceInfoMarshaller {
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceArn").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").build();
    private static final MarshallingInfo<Date> LASTMODIFIED_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModified").timestampFormat("unixTimestamp").build();
    private static final ResourceInfoMarshaller instance = new ResourceInfoMarshaller();

    public static ResourceInfoMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourceInfo resourceInfo, ProtocolMarshaller protocolMarshaller) {
        if (resourceInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(resourceInfo.getResourceArn(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall(resourceInfo.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall(resourceInfo.getLastModified(), LASTMODIFIED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

