/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model.transform;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.MarshallLocation;
import com.simba.athena.amazonaws.protocol.MarshallingInfo;
import com.simba.athena.amazonaws.protocol.MarshallingType;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.services.glue.model.SparkSQL;
import java.util.List;

@SdkInternalApi
public class SparkSQLMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<List> INPUTS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Inputs").build();
    private static final MarshallingInfo<String> SQLQUERY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SqlQuery").build();
    private static final MarshallingInfo<List> SQLALIASES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SqlAliases").build();
    private static final MarshallingInfo<List> OUTPUTSCHEMAS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputSchemas").build();
    private static final SparkSQLMarshaller instance = new SparkSQLMarshaller();

    public static SparkSQLMarshaller getInstance() {
        return instance;
    }

    public void marshall(SparkSQL sparkSQL, ProtocolMarshaller protocolMarshaller) {
        if (sparkSQL == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(sparkSQL.getName(), NAME_BINDING);
            protocolMarshaller.marshall(sparkSQL.getInputs(), INPUTS_BINDING);
            protocolMarshaller.marshall(sparkSQL.getSqlQuery(), SQLQUERY_BINDING);
            protocolMarshaller.marshall(sparkSQL.getSqlAliases(), SQLALIASES_BINDING);
            protocolMarshaller.marshall(sparkSQL.getOutputSchemas(), OUTPUTSCHEMAS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

