/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model.transform;

import com.simba.athena.amazonaws.services.glue.model.DynamoDBTarget;
import com.simba.athena.amazonaws.transform.JsonUnmarshallerContext;
import com.simba.athena.amazonaws.transform.Unmarshaller;
import com.simba.athena.shaded.fasterxml.jackson.core.JsonToken;

public class DynamoDBTargetJsonUnmarshaller
implements Unmarshaller<DynamoDBTarget, JsonUnmarshallerContext> {
    private static DynamoDBTargetJsonUnmarshaller instance;

    @Override
    public DynamoDBTarget unmarshall(JsonUnmarshallerContext context) throws Exception {
        DynamoDBTarget dynamoDBTarget = new DynamoDBTarget();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Path", targetDepth)) {
                    context.nextToken();
                    dynamoDBTarget.setPath(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("scanAll", targetDepth)) {
                    context.nextToken();
                    dynamoDBTarget.setScanAll(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("scanRate", targetDepth)) {
                    context.nextToken();
                    dynamoDBTarget.setScanRate(context.getUnmarshaller(Double.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return dynamoDBTarget;
    }

    public static DynamoDBTargetJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DynamoDBTargetJsonUnmarshaller();
        }
        return instance;
    }
}

