/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model.transform;

import com.simba.athena.amazonaws.services.glue.model.DeltaTarget;
import com.simba.athena.amazonaws.transform.JsonUnmarshallerContext;
import com.simba.athena.amazonaws.transform.ListUnmarshaller;
import com.simba.athena.amazonaws.transform.Unmarshaller;
import com.simba.athena.shaded.fasterxml.jackson.core.JsonToken;

public class DeltaTargetJsonUnmarshaller
implements Unmarshaller<DeltaTarget, JsonUnmarshallerContext> {
    private static DeltaTargetJsonUnmarshaller instance;

    @Override
    public DeltaTarget unmarshall(JsonUnmarshallerContext context) throws Exception {
        DeltaTarget deltaTarget = new DeltaTarget();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("DeltaTables", targetDepth)) {
                    context.nextToken();
                    deltaTarget.setDeltaTables(new ListUnmarshaller<String>(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("ConnectionName", targetDepth)) {
                    context.nextToken();
                    deltaTarget.setConnectionName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("WriteManifest", targetDepth)) {
                    context.nextToken();
                    deltaTarget.setWriteManifest(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return deltaTarget;
    }

    public static DeltaTargetJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DeltaTargetJsonUnmarshaller();
        }
        return instance;
    }
}

