/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model;

import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.protocol.StructuredPojo;
import com.simba.athena.amazonaws.services.glue.model.transform.S3TargetMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class S3Target
implements Serializable,
Cloneable,
StructuredPojo {
    private String path;
    private List<String> exclusions;
    private String connectionName;
    private Integer sampleSize;
    private String eventQueueArn;
    private String dlqEventQueueArn;

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public S3Target withPath(String path) {
        this.setPath(path);
        return this;
    }

    public List<String> getExclusions() {
        return this.exclusions;
    }

    public void setExclusions(Collection<String> exclusions) {
        if (exclusions == null) {
            this.exclusions = null;
            return;
        }
        this.exclusions = new ArrayList<String>(exclusions);
    }

    public S3Target withExclusions(String ... exclusions) {
        if (this.exclusions == null) {
            this.setExclusions(new ArrayList<String>(exclusions.length));
        }
        for (String ele : exclusions) {
            this.exclusions.add(ele);
        }
        return this;
    }

    public S3Target withExclusions(Collection<String> exclusions) {
        this.setExclusions(exclusions);
        return this;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public S3Target withConnectionName(String connectionName) {
        this.setConnectionName(connectionName);
        return this;
    }

    public void setSampleSize(Integer sampleSize) {
        this.sampleSize = sampleSize;
    }

    public Integer getSampleSize() {
        return this.sampleSize;
    }

    public S3Target withSampleSize(Integer sampleSize) {
        this.setSampleSize(sampleSize);
        return this;
    }

    public void setEventQueueArn(String eventQueueArn) {
        this.eventQueueArn = eventQueueArn;
    }

    public String getEventQueueArn() {
        return this.eventQueueArn;
    }

    public S3Target withEventQueueArn(String eventQueueArn) {
        this.setEventQueueArn(eventQueueArn);
        return this;
    }

    public void setDlqEventQueueArn(String dlqEventQueueArn) {
        this.dlqEventQueueArn = dlqEventQueueArn;
    }

    public String getDlqEventQueueArn() {
        return this.dlqEventQueueArn;
    }

    public S3Target withDlqEventQueueArn(String dlqEventQueueArn) {
        this.setDlqEventQueueArn(dlqEventQueueArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPath() != null) {
            sb.append("Path: ").append(this.getPath()).append(",");
        }
        if (this.getExclusions() != null) {
            sb.append("Exclusions: ").append(this.getExclusions()).append(",");
        }
        if (this.getConnectionName() != null) {
            sb.append("ConnectionName: ").append(this.getConnectionName()).append(",");
        }
        if (this.getSampleSize() != null) {
            sb.append("SampleSize: ").append(this.getSampleSize()).append(",");
        }
        if (this.getEventQueueArn() != null) {
            sb.append("EventQueueArn: ").append(this.getEventQueueArn()).append(",");
        }
        if (this.getDlqEventQueueArn() != null) {
            sb.append("DlqEventQueueArn: ").append(this.getDlqEventQueueArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Target)) {
            return false;
        }
        S3Target other = (S3Target)obj;
        if (other.getPath() == null ^ this.getPath() == null) {
            return false;
        }
        if (other.getPath() != null && !other.getPath().equals(this.getPath())) {
            return false;
        }
        if (other.getExclusions() == null ^ this.getExclusions() == null) {
            return false;
        }
        if (other.getExclusions() != null && !other.getExclusions().equals(this.getExclusions())) {
            return false;
        }
        if (other.getConnectionName() == null ^ this.getConnectionName() == null) {
            return false;
        }
        if (other.getConnectionName() != null && !other.getConnectionName().equals(this.getConnectionName())) {
            return false;
        }
        if (other.getSampleSize() == null ^ this.getSampleSize() == null) {
            return false;
        }
        if (other.getSampleSize() != null && !other.getSampleSize().equals(this.getSampleSize())) {
            return false;
        }
        if (other.getEventQueueArn() == null ^ this.getEventQueueArn() == null) {
            return false;
        }
        if (other.getEventQueueArn() != null && !other.getEventQueueArn().equals(this.getEventQueueArn())) {
            return false;
        }
        if (other.getDlqEventQueueArn() == null ^ this.getDlqEventQueueArn() == null) {
            return false;
        }
        return other.getDlqEventQueueArn() == null || other.getDlqEventQueueArn().equals(this.getDlqEventQueueArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPath() == null ? 0 : this.getPath().hashCode());
        hashCode = 31 * hashCode + (this.getExclusions() == null ? 0 : this.getExclusions().hashCode());
        hashCode = 31 * hashCode + (this.getConnectionName() == null ? 0 : this.getConnectionName().hashCode());
        hashCode = 31 * hashCode + (this.getSampleSize() == null ? 0 : this.getSampleSize().hashCode());
        hashCode = 31 * hashCode + (this.getEventQueueArn() == null ? 0 : this.getEventQueueArn().hashCode());
        hashCode = 31 * hashCode + (this.getDlqEventQueueArn() == null ? 0 : this.getDlqEventQueueArn().hashCode());
        return hashCode;
    }

    public S3Target clone() {
        try {
            return (S3Target)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3TargetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

