/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.athenastreamingservice;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.simba.athena.amazonaws.ClientConfiguration;
import com.simba.athena.amazonaws.annotation.ThreadSafe;
import com.simba.athena.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.simba.athena.amazonaws.client.AwsAsyncClientParams;
import com.simba.athena.amazonaws.handlers.AsyncHandler;
import com.simba.athena.amazonaws.services.athenastreamingservice.AthenaStreamingServiceAsync;
import com.simba.athena.amazonaws.services.athenastreamingservice.AthenaStreamingServiceAsyncClientBuilder;
import com.simba.athena.amazonaws.services.athenastreamingservice.AthenaStreamingServiceClient;
import com.simba.athena.amazonaws.services.athenastreamingservice.model.GetQueryResultsStreamRequest;
import com.simba.athena.amazonaws.services.athenastreamingservice.model.GetQueryResultsStreamResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AthenaStreamingServiceAsyncClient
extends AthenaStreamingServiceClient
implements AthenaStreamingServiceAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AthenaStreamingServiceAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AthenaStreamingServiceAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AthenaStreamingServiceAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AthenaStreamingServiceAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AthenaStreamingServiceAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AthenaStreamingServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AthenaStreamingServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AthenaStreamingServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AthenaStreamingServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AthenaStreamingServiceAsyncClientBuilder asyncBuilder() {
        return AthenaStreamingServiceAsyncClientBuilder.standard();
    }

    AthenaStreamingServiceAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<GetQueryResultsStreamResult> getQueryResultsStreamAsync(GetQueryResultsStreamRequest request) {
        return this.getQueryResultsStreamAsync(request, null);
    }

    @Override
    public Future<GetQueryResultsStreamResult> getQueryResultsStreamAsync(GetQueryResultsStreamRequest request, final AsyncHandler<GetQueryResultsStreamRequest, GetQueryResultsStreamResult> asyncHandler) {
        final GetQueryResultsStreamRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetQueryResultsStreamResult>(){

            @Override
            public GetQueryResultsStreamResult call() throws Exception {
                GetQueryResultsStreamResult result = null;
                try {
                    result = AthenaStreamingServiceAsyncClient.this.executeGetQueryResultsStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

