/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.athena.model.transform;

import com.simba.athena.amazonaws.services.athena.model.PreparedStatement;
import com.simba.athena.amazonaws.transform.JsonUnmarshallerContext;
import com.simba.athena.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.simba.athena.amazonaws.transform.Unmarshaller;
import com.simba.athena.shaded.fasterxml.jackson.core.JsonToken;

public class PreparedStatementJsonUnmarshaller
implements Unmarshaller<PreparedStatement, JsonUnmarshallerContext> {
    private static PreparedStatementJsonUnmarshaller instance;

    @Override
    public PreparedStatement unmarshall(JsonUnmarshallerContext context) throws Exception {
        PreparedStatement preparedStatement = new PreparedStatement();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("StatementName", targetDepth)) {
                    context.nextToken();
                    preparedStatement.setStatementName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("QueryStatement", targetDepth)) {
                    context.nextToken();
                    preparedStatement.setQueryStatement(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("WorkGroupName", targetDepth)) {
                    context.nextToken();
                    preparedStatement.setWorkGroupName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    preparedStatement.setDescription(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LastModifiedTime", targetDepth)) {
                    context.nextToken();
                    preparedStatement.setLastModifiedTime(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return preparedStatement;
    }

    public static PreparedStatementJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PreparedStatementJsonUnmarshaller();
        }
        return instance;
    }
}

