/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.auth;

import com.simba.athena.amazonaws.AbortedException;
import com.simba.athena.amazonaws.AmazonClientException;
import com.simba.athena.amazonaws.AmazonServiceException;
import com.simba.athena.amazonaws.annotation.NotThreadSafe;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.annotation.ThreadSafe;
import com.simba.athena.amazonaws.auth.DaemonThreadFactory;
import com.simba.athena.amazonaws.internal.SdkPredicate;
import com.simba.athena.amazonaws.util.ValidationUtils;
import java.io.Closeable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@ThreadSafe
@SdkInternalApi
class RefreshableTask<T>
implements Closeable {
    private static final long BLOCKING_REFRESH_MAX_WAIT_IN_SECONDS = 5L;
    private final Lock blockingRefreshLock = new ReentrantLock();
    private final AtomicReference<T> refreshableValueHolder = new AtomicReference();
    private final ExecutorService executor;
    private final boolean shouldShutdownExecutor;
    private final AtomicBoolean asyncRefreshing = new AtomicBoolean(false);
    private final Callable<T> refreshCallable;
    private final SdkPredicate<T> shouldDoBlockingRefresh;
    private final SdkPredicate<T> shouldDoAsyncRefresh;

    private RefreshableTask(Callable<T> refreshCallable, SdkPredicate<T> shouldDoBlockingRefresh, SdkPredicate<T> shouldDoAsyncRefresh) {
        this(refreshCallable, shouldDoBlockingRefresh, shouldDoAsyncRefresh, Executors.newSingleThreadExecutor(new DaemonThreadFactory()), true);
    }

    private RefreshableTask(Callable<T> refreshCallable, SdkPredicate<T> shouldDoBlockingRefresh, SdkPredicate<T> shouldDoAsyncRefresh, ExecutorService executor) {
        this(refreshCallable, shouldDoBlockingRefresh, shouldDoAsyncRefresh, executor, false);
    }

    private RefreshableTask(Callable<T> refreshCallable, SdkPredicate<T> shouldDoBlockingRefresh, SdkPredicate<T> shouldDoAsyncRefresh, ExecutorService executor, boolean shouldShutdownExecutor) {
        this.refreshCallable = ValidationUtils.assertNotNull(refreshCallable, "refreshCallable");
        this.shouldDoBlockingRefresh = ValidationUtils.assertNotNull(shouldDoBlockingRefresh, "shouldDoBlockingRefresh");
        this.shouldDoAsyncRefresh = ValidationUtils.assertNotNull(shouldDoAsyncRefresh, "shouldDoAsyncRefresh");
        this.executor = ValidationUtils.assertNotNull(executor, "executor");
        this.shouldShutdownExecutor = shouldShutdownExecutor;
    }

    @Override
    public void close() {
        if (this.shouldShutdownExecutor) {
            this.executor.shutdown();
        }
    }

    public T getValue() throws AmazonClientException, IllegalStateException {
        if (this.shouldDoBlockingRefresh()) {
            this.blockingRefresh();
        } else if (this.shouldDoAsyncRefresh()) {
            this.asyncRefresh();
        }
        return this.getRefreshedValue();
    }

    public T forceGetValue() {
        this.refreshValue();
        return this.getRefreshedValue();
    }

    private T getRefreshedValue() throws IllegalStateException {
        T refreshableValue = this.refreshableValueHolder.get();
        if (refreshableValue != null) {
            return refreshableValue;
        }
        throw new IllegalStateException("Refreshed value should never be null.");
    }

    private boolean shouldDoBlockingRefresh() {
        return this.shouldDoBlockingRefresh.test(this.refreshableValueHolder.get());
    }

    private boolean shouldDoAsyncRefresh() {
        return this.shouldDoAsyncRefresh.test(this.refreshableValueHolder.get());
    }

    private void blockingRefresh() {
        try {
            if (this.blockingRefreshLock.tryLock(5L, TimeUnit.SECONDS)) {
                try {
                    if (!this.shouldDoBlockingRefresh()) {
                        return;
                    }
                    this.refreshValue();
                    return;
                }
                finally {
                    this.blockingRefreshLock.unlock();
                }
            }
        }
        catch (InterruptedException ex) {
            this.handleInterruptedException("Interrupted waiting to refresh the value.", ex);
        }
        this.refreshValue();
    }

    private void asyncRefresh() {
        if (this.asyncRefreshing.compareAndSet(false, true)) {
            try {
                this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RefreshableTask.this.refreshValue();
                        }
                        finally {
                            RefreshableTask.this.asyncRefreshing.set(false);
                        }
                    }
                });
            }
            catch (RuntimeException ex) {
                this.asyncRefreshing.set(false);
                throw ex;
            }
        }
    }

    private void refreshValue() {
        try {
            this.refreshableValueHolder.compareAndSet(this.refreshableValueHolder.get(), this.refreshCallable.call());
        }
        catch (AmazonServiceException ase) {
            throw ase;
        }
        catch (AmazonClientException ace) {
            throw ace;
        }
        catch (Exception e) {
            throw new AmazonClientException(e);
        }
    }

    private void handleInterruptedException(String message, InterruptedException cause) {
        Thread.currentThread().interrupt();
        throw new AbortedException(message, cause);
    }

    @NotThreadSafe
    public static class Builder<T> {
        private Callable<T> refreshCallable;
        private SdkPredicate<T> shouldDoBlockingRefresh;
        private SdkPredicate<T> shouldDoAsyncRefresh;
        private ExecutorService executorService;

        public Builder withRefreshCallable(Callable<T> refreshCallable) {
            this.refreshCallable = refreshCallable;
            return this;
        }

        public Builder withBlockingRefreshPredicate(SdkPredicate<T> shouldDoBlockingRefresh) {
            this.shouldDoBlockingRefresh = shouldDoBlockingRefresh;
            return this;
        }

        public Builder withAsyncRefreshPredicate(SdkPredicate<T> shouldDoAsyncRefresh) {
            this.shouldDoAsyncRefresh = shouldDoAsyncRefresh;
            return this;
        }

        public Builder withExecutorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public RefreshableTask<T> build() {
            if (this.executorService == null) {
                return new RefreshableTask((Callable)this.refreshCallable, (SdkPredicate)this.shouldDoBlockingRefresh, (SdkPredicate)this.shouldDoAsyncRefresh);
            }
            return new RefreshableTask(this.refreshCallable, this.shouldDoBlockingRefresh, this.shouldDoAsyncRefresh, this.executorService);
        }
    }
}

